<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );

// W functions.php motywu potomnego
add_action( 'init', function () {
    // Usuwa domyślne taby WooCommerce
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

    add_filter( 'woocommerce_product_tabs', function( $tabs ) {
        unset( $tabs['description'], $tabs['reviews'], $tabs['additional_information'] );
        return $tabs;
    }, 98 );

    // Gdyby recenzje szły jeszcze jako zwykłe komentarze pod produktem:
    remove_action( 'woocommerce_after_single_product_summary', 'comments_template', 50 );
});