
// =============================================================================
// Single Product Sliders
// =============================================================================

barberry.singleProductSlider = function() {

    (function() {
        var touchingCarousel = false,
          touchStartCoords;

        document.body.addEventListener('touchstart', function(e) {
          if (e.target.closest('.flickity-slider')) {
            touchingCarousel = true;
          } else {
            touchingCarousel = false;
            return;
          }

          touchStartCoords = {
            x: e.touches[0].pageX,
            y: e.touches[0].pageY
          }
        });

        document.body.addEventListener('touchmove', function(e) {
          if (!(touchingCarousel && e.cancelable)) {
            return;
          }

          var moveVector = {
            x: e.touches[0].pageX - touchStartCoords.x,
            y: e.touches[0].pageY - touchStartCoords.y
          };

          if (Math.abs(moveVector.x) > 7)
            e.preventDefault()

        }, {passive: false});
      })();

    

    if ( !barberry.$body.hasClass('single-product') ) {
        return;
    }

    var carouselContainers = document.querySelectorAll('.product_related_wrapper');

    for ( var i=0; i < carouselContainers.length; i++ ) {
      var container = carouselContainers[i];
      initCarouselContainer( container );
    }   

    function initCarouselContainer( container ) {
        var related_carousel = container.querySelector('.related ul.products'),
            uppsell_carousel = container.querySelector('.upsells ul.products');

        if ( $('.single-product .related').length > 0 ) {

            var related_col = barberry_scripts_vars.related_products_columns,
                related_no = parseInt($(".related").attr('data-related-no'));

                if (related_no > related_col) {

                    var flkty = new Flickity( related_carousel, {
                        // options
                        lazyLoad: true,
                        imagesLoaded: true,
                        cellAlign: 'left',
                        contain: true,
                        groupCells: false,
                        pageDots: true,
                        rightToLeft: (barberry_scripts_vars.rtl === 'true'),
                        arrowShape: { 
                            x0: 10,
                            x1: 60, y1: 50,
                            x2: 60, y2: 40,
                            x3: 20
                        },            
                    });                    


                    flkty.on( 'change', function( index ) {
                        barberry.lazyLoad();
                        $("ul.products .product").addClass('active');                      
                    });
                    
                }


        }

        if ( $('.single-product .upsells').length > 0 ) {

            var upsells_col = barberry_scripts_vars.upsells_products_columns,
                upsells_no = parseInt($(".upsells").attr('data-upsells-no'));

            if (upsells_no > upsells_col) {
                var flkty = new Flickity( uppsell_carousel, {
                    // options
                    lazyLoad: true,
                    imagesLoaded: true,
                    cellAlign: 'left',
                    contain: true,
                    groupCells: false,
                    pageDots: true,
                    rightToLeft: (barberry_scripts_vars.rtl === 'true'),
                    arrowShape: { 
                        x0: 10,
                        x1: 60, y1: 50,
                        x2: 60, y2: 40,
                        x3: 20
                    },
            
                }); 

                flkty.on( 'change', function( index ) {
                    barberry.lazyLoad();
                    $("ul.products .product").addClass('active');                    
                });

            }            
        } 
    }
}


