<?php

namespace CleantalkSP\SpbctWP;

class Escape extends \CleantalkSP\Common\Escape
{
    /**
     * Simple method: escape attribute
     *
     * @param $text
     *
     * @return string
     */
    public static function escAttr($text)
    {
        return esc_attr($text);
    }

    /**
     * Simple method: escape html
     *
     * @param $text
     *
     * @return string
     */
    public static function escHtml($text)
    {
        return esc_html($text);
    }

    /**
     * Simple method: escape js
     *
     * @param $text
     *
     * @return string
     */
    public static function escJs($text)
    {
        return esc_js($text);
    }

    /**
     * Simple method: escape textarea
     *
     * @param $text
     *
     * @return string
     */
    public static function escTextarea($text)
    {
        return esc_textarea($text);
    }

    /**
     * Simple method: escape url
     *
     * @param $text
     *
     * @return string
     */
    public static function escUrl($text)
    {
        return esc_url($text);
    }

    /**
     * Simple method: escape url raw
     *
     * @param $text
     *
     * @return string
     */
    public static function escUrlRaw($text)
    {
        return esc_url_raw($text);
    }

    /**
     * Simple method: escape kses
     *
     * @param $string
     * @param $allowed_html
     * @param array $allowed_protocols
     *
     * @return string
     */
    public static function escKses($string, $allowed_html, $allowed_protocols = array())
    {
        return wp_kses($string, $allowed_html, $allowed_protocols = array());
    }

    public static function escKsesPreset($string, $preset = null, $_allowed_protocols = array())
    {

        $kses_presets = array(
            'spbc_settings__display__notifications' => array(
                'a' => array(
                    'target' => true,
                    'href' => true,
                ),
            ),
            'spbc_settings__notice_autosend' => array(
                'div' => array(
                    'class' => true,
                ),
                'p' => array(
                ),
                'img' => array(
                    'src' => true,
                    'alt' => true,
                    'style' => true,
                ),
            )
        );

        if ( !empty($kses_presets[$preset]) ) {
            $allowed_html = $kses_presets[$preset];
            return self::escKses($string, $allowed_html, $allowed_protocols = array());
        }

        return self::escKses($string, $allowed_html = array(), $allowed_protocols = array());
    }

    /**
     * Simple method: escape kses post
     *
     * @param $data
     *
     * @return string
     */
    public static function escKsesPost($data)
    {
        return wp_kses_post($data);
    }
}
