<?php

require_once BARBERRY_THEME_PATH . '/inc/fonts/class-tdl-add-custom-fonts.php';

/**
 * Create Instance
 */
function barberry_add_custom_fonts() {
	return Barberry_Add_Custom_Fonts::instance();
}
barberry_add_custom_fonts();

/**
 * Add custom fonts choice
 */
function barberry_add_custom_choice() {
	return array(
		'fonts' => apply_filters( 'barberry/kirki_font_choices', array() ),
	);
}


/**
 * Force Load all fonts variations (Kirki)
 */
add_action( 'after_setup_theme', 'barberry_font_add_all_variants', 100 );
function barberry_font_add_all_variants() {

	$force_load_all_fonts_variations = get_theme_mod( 'force_load_all_fonts_variations', false );

	if ( class_exists( 'Kirki_Fonts_Google' ) && $force_load_all_fonts_variations ) {
		Kirki_Fonts_Google::$force_load_all_variants = true;
	}

}