<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 4.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$show_reg_form = ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) ? true : false;
$account_link = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) );

?>


<!-- begin grid-x -->
<div class="grid-x login-cells">
	
	<!-- begin login-content -->
	<div id="customer_login" class="login-content">

		<?php do_action( 'woocommerce_before_customer_login_form' ); ?>

		<!-- begin login-content-inner -->
		<div class="login-content-inner">

			
			<div id="bb-login-wrap" class="inline slide-up fade-in">
				<div class="title-wrapper">
					<?php barberry_breadcrumbs(); ?>
					<div class="page-title-wrapper">
						<h1 class="page-title"><?php esc_html_e( 'Log in', 'woocommerce' ); ?></h1>
					</div>					
				</div>

				<?php barberry_login_form( true, add_query_arg( 'action', 'login', $account_link ) ); ?>

	                    <?php if ( $show_reg_form ) : ?>
	                    <div class="bb-login-form-divider"><span><?php esc_html_e( 'Or', 'barberry' ); ?></span></div>
	                    <a href="#" id="bb-show-register-button" class="button btn--border"><?php esc_html_e( 'Create an Account', 'barberry' ); ?></a>
	                    <?php endif; ?>				

			</div>

			<?php if ( $show_reg_form ) : ?>
				<div id="bb-register-wrap">
					<div class="title-wrapper">
						<?php barberry_breadcrumbs(); ?>
						<div class="page-title-wrapper">
							<h1 class="page-title"><?php esc_html_e( 'Register', 'woocommerce' ); ?></h1>
						</div>					
					</div>

					<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >
						<?php do_action( 'woocommerce_register_form_start' ); ?>
						<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

						    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
								<label for="reg_username"><?php esc_html_e( 'Username', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
								<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
							</p>

						<?php endif; ?>

						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
							<label for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
							<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
						</p>

						<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

					    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
							<label for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
							<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
						</p>
						<?php else : ?>
						<div class="woocommerce-password-text"><p><?php esc_html_e( 'A password will be sent to your email address.', 'woocommerce' ); ?></p></div>

						<?php endif; ?>

						<?php do_action( 'woocommerce_register_form' ); ?>

						<p class="form-actions woocommerce-form-row">
						    <?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
						    <button type="submit" class="woocommerce-Button button" name="register" value="<?php esc_attr_e( 'Register', 'woocommerce' ); ?>"><?php esc_html_e( 'Register', 'woocommerce' ); ?></button>
						    
						    <?php if ( $show_reg_form ) : ?>
						    <div class="bb-login-form-divider"><span><?php esc_html_e( 'Or', 'barberry' ); ?></span></div>
						    
						    <a href="#" id="bb-show-login-button" class="button btn--border"><?php esc_html_e( 'Log in', 'woocommerce' ); ?></a>
						    <?php endif; ?>
						</p>

						<?php do_action( 'woocommerce_register_form_end' ); ?>						
					</form>					
				</div>
			<?php endif; ?>
			<?php do_action( 'woocommerce_after_customer_login_form' ); ?>	

		</div>
		<!-- end login-content-inner -->
		
	</div>
	<!-- end login-content -->

</div>
<!-- end grid-x -->