<?php

namespace nordmind\AdminBundle\Controller;

use nordmind\AdminBundle\Entity\SystemOption;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use nordmind\AdminBundle\Form\SystemOptionType;
use nordmind\AdminBundle\Entity\SystemOptionRepository;
use nordmind\AppBundle\Utility;
use Symfony\Component\Security\Http\Session;

class DefaultController extends Controller
{

    /**
     * @Route("/", name="nordmind_admin_index")
     */
    public function indexAction()
    {
        return $this->render('nordmindAdminBundle:Default:index.html.twig');
    }

    /**
     * @Route("/configuration", name="nordmind_admin_configuration")
     */
    public function configurationAction(Request $request)
    {
        $form = $this->createForm(SystemOptionType::class, null);

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $systemOptions = Utility::getMethodArray($em->getRepository('nordmindAdminBundle:SystemOption')->findAll(), "getName");
            $data = $form->getData();

            foreach ($data as $systemOptionKey => $systemOptionValue) {
                $systemOption = isset($systemOptions[$systemOptionKey]) ? $systemOptions[$systemOptionKey] : null;
                if ($systemOption) {
                    $systemOption->setValue($systemOptionValue);
                } else {
                    $systemOption = new SystemOption();
                    $systemOption->setName($systemOptionKey);
                    $systemOption->setValue($systemOptionValue);
                }
                $em->persist($systemOption);
            }
            $em->flush();
            $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Zapisano zmiany.')
            ;
        }

        return $this->render('nordmindAdminBundle:Default:configuration.html.twig', array('form' => $form->createView()));
    }

    /**
     * @Route("/showDeleted", name="nordmind_admin_show_deleted")
     */
    public function showDeletedAction(Request $request)
    {
        $state = $request->request->get('state');
        $session = $request->getSession();
        $session->set("show_deleted", $state);
        $message = $state ? "Wyświetlanie danych usuniętych." : "Ukrycie danych usuniętych";
        $response = new JsonResponse(array('message' => $message, 'callback' => "c_reloadWindow()"));
        return $response;
    }

}
