<?php

namespace nordmind\AdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints as Asserts;
use Kiczort\PolishValidatorBundle\Validator\Constraints\Nip;
use nordmind\AppBundle\Utility;

class SystemOptionType extends AbstractType
{
    private $em;

    public function __construct(EntityManager $em)
    {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $systemOptions = Utility::getKeyValueMethodArray($this->em->getRepository('nordmindAdminBundle:SystemOption')->findAll(),"getName", "getValue");
        $builder
            ->add('issuer_name', TextType::class, array('required' => true, 'label' => 'Nazwa firmy/organizacji*', 'data' => isset($systemOptions['issuer_name']) ? $systemOptions['issuer_name'] : ''))
            ->add('issuer_address', TextareaType::class, array('required' => false, 'label' => 'Adres', 'data' => isset($systemOptions['issuer_address']) ? $systemOptions['issuer_address'] : ''))
            ->add('issuer_phone', TextType::class, array('required' => false, 'label' => 'Telefon kontaktowy', 'data' => isset($systemOptions['issuer_phone']) ? $systemOptions['issuer_phone'] : ''))
            ->add('issuer_email', TextType::class, array('constraints' => new Asserts\Email(), 'required' => false, 'label' => 'Adres email', 'data' => isset($systemOptions['issuer_email']) ? $systemOptions['issuer_email'] : ''))
            ->add('issuer_street', TextType::class, array('required' => false, 'label' => 'Ulica i numer', 'data' => isset($systemOptions['issuer_street']) ? $systemOptions['issuer_street'] : ''))
            ->add('issuer_city', TextType::class, array('required' => false, 'label' => 'Miejscowosc', 'data' => isset($systemOptions['issuer_city']) ? $systemOptions['issuer_city'] : ''))
            ->add('issuer_postcode', TextType::class, array('required' => false, 'label' => 'Kod pocztowy', 'data' => isset($systemOptions['issuer_postcode']) ? $systemOptions['issuer_postcode'] : ''))
            ->add('issuer_taxnumber', TextType::class, array('constraints' => new NIP(), 'required' => false, 'label' => 'NIP', 'data' => isset($systemOptions['issuer_taxnumber']) ? $systemOptions['issuer_taxnumber'] : ''))
            ->add('send', SubmitType::class, array('label' => 'Zapisz', 'attr' => array('class' => 'btn btn-primary')));
    }
}
