<?php

namespace nordmind\AdminBundle\Listener;

use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;
use Symfony\Component\Security\Core\Authorization\AuthorizationChecker;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use \Doctrine\ORM\EntityManager;
use nordmind\AppBundle\Utility;
use FOS\MessageBundle\Provider\Provider;

class AfterLoginListener
{
    private $tokenStorage;
    private $authorizationChecker;
    private $session;
    private $em;
    private $provider;

    public function __construct(TokenStorage $tokenStorage, AuthorizationChecker $authorizationChecker, Session $session, EntityManager $em, Provider $provider)
    {
        $this->tokenStorage = $tokenStorage;
        $this->authorizationChecker = $authorizationChecker;
        $this->session = $session;
        $this->em = $em;
        $this->provider = $provider;
    }

    public function onSecurityInteractiveLogin(InteractiveLoginEvent $event)
    {
        if ($this->authorizationChecker->isGranted('ROLE_ADMIN')) {
            $systemOptions = Utility::getKeyValueMethodArray($this->em->getRepository('nordmindAdminBundle:SystemOption')->findAll(), "getName", "getValue");
            foreach ($systemOptions as $key => $value) {
                $this->session->set($key, $value);
            }
        }
        $this->session->set("message_unread_number", $this->provider->getNbUnreadMessages());
        $users = $this->em->getRepository('nordmindUserBundle:User')->findBy(array(), array('lastName' => 'ASC', 'name' => 'ASC'));
        $usersArray = array();
        foreach ($users as $user) {
            $tmpArray = array();
            $tmpArray["id"] = $user->getId();
            $tmpArray["name"] = $user->getName();
            $tmpArray["lastName"] = $user->getLastName();
            $tmpArray["email"] = $user->getEmail();
            $tmpArray["hasLogo"] = $user->getHasLogo();
            $usersArray[$user->getId()] = $tmpArray;
        }
        $this->session->set("users_array", $usersArray);
        dump($usersArray);die;
    }

}
