<?php

namespace nordmind\AppBundle\Controller;

use nordmind\AppBundle\Form\NewsletterType;
use Proxies\__CG__\nordmind\AppBundle\Entity\Newsletter;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use nordmind\AppBundle\Utility;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use nordmind\UserBundle\Entity\User;
use Symfony\Component\HttpFoundation\JsonResponse;
use nordmind\ArtistBundle\Entity\Category;
use nordmind\ArtistBundle\Entity\Theme;

class DefaultController extends Controller
{
    /**
     * @Route("/artist", name="nordmind_artist_index")
     * @Route("/p/{slug}", name="nordmind_artist_profile_index")
     */
    public function profileAction(User $user = null)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $user ?? $this->getUser();
        $categories = $user->getCategories();
        $photos = $user->getPhotos();
        if (!$photos)
        {
            if ($user == $this->getUser()) {
                return new RedirectResponse($this->generateUrl('nordmind_artist_work'));
            }
            else
            {
                return new RedirectResponse($this->generateUrl('nordmind_app_index'));
            }
        }
        $em = $this->getDoctrine()->getManager();
        return $this->render('nordmindArtistBundle:Default:index.html.twig', array('user' => $user, 'photos' => $photos, 'categories' => $categories));
    }

    /**
     * @Route("/about", name="nordmind_app_about")
     */
    public function aboutAction()
    {
        return $this->render('nordmindAppBundle:Default:about.html.twig', array());
    }

    /**
     * @Route("/preRegister", name="nordmind_app_pre_register")
     */
    public function preRegisterAction()
    {
        return $this->render('nordmindAppBundle:Default:preRegister.html.twig', array());
    }

    /**
     * @Route("/clients", name="nordmind_app_clients")
     */
    public function clientsAction()
    {
        return $this->render('nordmindAppBundle:Default:clients.html.twig', array());
    }

    /**
     * @Route("/review", name="nordmind_app_review")
     */
    public function reviewAction()
    {
        $em = $this->getDoctrine()->getManager();
        $photos = $em->getRepository('nordmindArtistBundle:Photo')->getReview(array(Category::PORTRAIT));
        return $this->render('nordmindAppBundle:Default:review.html.twig', array('photos' => $photos));
    }

    /**
     * @Route("/favorite", name="nordmind_app_favorite")
     *
     */
    public function favoriteAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $categories = [];
        $favorites = $user->getFavorites();
        $photos = [];
        foreach ($favorites as $favorite)
        {
            $photo = $favorite->getPhoto();
            $photos[] = $photo;
            foreach ($photo->getCategories() as $category)
            {
                $categories[$category->getCategory()] = $category->getCategory();
            }
        }
        return $this->render('nordmindAppBundle:Default:favorite.html.twig', array('photos' => $photos, 'categories' => $categories));
    }

    /**
     * @Route("/artists/{sortBy}/{searchFor}", name="nordmind_app_artists")
     */
    public function artistsAction(Request $request, $sortBy = 'date', $searchFor = 'work')
    {
        $em = $this->getDoctrine()->getManager();
        $categories = Category::getAll();
        $themes = Theme::getAll();

        if ($request->isMethod('POST'))
        {
            Utility::setNavigationFilter($request, 'search-artist', null);
            $searchArtists = null;
            Utility::setNavigationFilter($request, 'search-tags', null);
            $searchTags = null;
            Utility::setNavigationFilter($request, 'search-category', null);
            $searchCategories = [];
            Utility::setNavigationFilter($request, 'search-theme', null);
            $searchThemes = [];
        }
        $searchFor = Utility::retrieveNavigationFilter($request, 'searchFor');
        $sortBy = Utility::retrieveNavigationFilter($request, 'sortBy');
        $searchFor = $searchFor == null ? 'work' : $searchFor;
        if ($request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'searchFor', 'work');
            $searchFor = 'work';
        }
        $searchProfession = Utility::retrieveNavigationFilter($request, 'search-profession');
        $searchProfession = $searchProfession == null ? 'photographer' : $searchProfession;
        if ($request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'search-profession', 'photographer');
            $searchProfession = 'photographer';
        }
        $searchArtists = Utility::retrieveNavigationFilter($request, 'search-artist');
        if ($searchArtists == "clear" || $request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'search-artist', null);
            $searchArtists = null;
        }
        $searchTags = Utility::retrieveNavigationFilter($request, 'search-tags');
        if ($searchTags == "clear" || $request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'search-tag', null);
            $searchTags = null;
        }
        $searchCategories = Utility::retrieveNavigationFilter($request, 'search-category');
        if ($searchCategories == "clear" || $request->get('clearAll') || $request->get('search-categories-clear') == 'true')
        {
            Utility::setNavigationFilter($request, 'search-category', null);
            $searchCategories = [];
        }
        $searchThemes = Utility::retrieveNavigationFilter($request, 'search-theme');
        if ($searchThemes == "clear" || $request->get('clearAll') || $request->get('search-themes-clear') == 'true')
        {
            Utility::setNavigationFilter($request, 'search-theme', null);
            $searchThemes = [];
        }
        return $this->render('nordmindAppBundle:Default:artists.html.twig', array(
                    'searchFor' => $searchFor,
                    'categories' => $categories,
                    'themes' => $themes,
                    'searchArtist' => $searchArtists,
                    'searchProfession' => $searchProfession,
                    'searchTags' => $searchTags,
                    'searchCategories' => $searchCategories ? array_flip($searchCategories) : [],
                    'searchThemes' => $searchThemes ? array_flip($searchThemes) : [],
                    'sortBy' => $sortBy
        ));
    }

    /**
     * @Route("/artistsPhotos/{page}", name="nordmind_app_artists_photos", requirements={"page"="\d+"})
     */
    public function artistsPhotosAction(Request $request, $page = 1)
    {
        $em = $this->getDoctrine()->getManager();
        $categories = Category::getAll();
        $themes = Theme::getAll();
        $searchArtists = Utility::retrieveNavigationFilter($request, 'search-artist');
        $searchProfession = Utility::retrieveNavigationFilter($request, 'search-profession');
        $searchProfession = $searchProfession == null ? 'photographers' : $searchProfession;
        $searchFor = Utility::retrieveNavigationFilter($request, 'searchFor');
        $searchFor = $searchFor == null ? 'work' : $searchFor;
        $sortBy = Utility::retrieveNavigationFilter($request, 'sortBy');
        if ($request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'searchFor', 'work');
            $searchFor = 'work';
        }
        if ($searchProfession == "clear" || $request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'search-profession', null);
            $searchProfession = null;
        }
        if ($searchArtists == "clear" || $request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'search-artist', null);
            $searchArtists = null;
        }
        $searchTags = Utility::retrieveNavigationFilter($request, 'search-tags');
        if ($searchTags == "clear" || $request->get('clearAll'))
        {
            Utility::setNavigationFilter($request, 'search-tag', null);
            $searchTags = null;
        }
        $searchCategories = Utility::retrieveNavigationFilter($request, 'search-category');
        if ($searchCategories == "clear" || $request->get('clearAll') || $request->get('search-categories-clear') == 'true')
        {
            Utility::setNavigationFilter($request, 'search-category', null);
            $searchCategories = [];
        }
        $searchThemes = Utility::retrieveNavigationFilter($request, 'search-theme');
        if ($searchThemes == "clear" || $request->get('clearAll') || $request->get('search-themes-clear') == 'true')
        {
            Utility::setNavigationFilter($request, 'search-theme', null);
            $searchThemes = [];
        }
        if ($searchFor == 'work') {
            $users = null;
            $photos = $em->getRepository('nordmindArtistBundle:Photo')->search($searchProfession, $searchArtists, $searchTags, $searchCategories, $searchThemes, $page, $sortBy);
            $view = 'nordmindAppBundle:Default:photoGrid.html.twig';
        }
        else
        {
            $photos = null;
            $users = $em->getRepository('nordmindUserBundle:User')->search($searchProfession, $searchArtists, $searchTags, $searchCategories, $searchThemes, $page, $sortBy);
            $view = 'nordmindAppBundle:Default:artistGrid.html.twig';
        }
        return $this->render($view, array(
            'users' => $users,
            'photos' => $photos,
            'categories' => $categories,
            'themes' => $themes,
            'searchArtist' => $searchArtists,
            'searchTags' => $searchTags,
            'searchCategories' => $searchCategories ? array_flip($searchCategories) : [],
            'searchThemes' => $searchThemes ? array_flip($searchThemes) : [],
            'sortBy' => $sortBy
        ));
    }

    /**
     * @Route("/artistsRemoveFilter/{type}/{value}", name="nordmind_app_artists_remove_filter")
     */
    public function artistsRemoveFilter(Request $request, $type, $value)
    {
        if ($type == 'categories') {
            $searchCategories = Utility::retrieveNavigationFilter($request, 'search-category');
            $searchCategories = array_diff($searchCategories, [$value]);
            Utility::setNavigationFilter($request, 'search-category', $searchCategories);
        }
        if ($type == 'themes') {
            $searchThemes = Utility::retrieveNavigationFilter($request, 'search-theme');
            $searchThemes = array_diff($searchThemes, [$value]);
            Utility::setNavigationFilter($request, 'search-theme', $searchThemes);
        }
        if ($type == 'artist')
        {
            Utility::setNavigationFilter($request, 'search-artist', null);
        }
        if ($type == 'tags')
        {
            Utility::setNavigationFilter($request, 'search-tags', null);
        }

        return new RedirectResponse($request
            ->headers
            ->get('referer'));
    }

    /**
     * @Route("/newsletter", name="nordmind_app_newsletter")
     */
    public function newsletterAction(Request $request)
    {
        $form = $this->createForm(NewsletterType::class, null);

        $form->handleRequest($request);
        $email = null;
        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $newsletter = $form->getData();
            $tokenGenerator = $this->container->get('fos_user.util.token_generator');
            $newsletter->setToken($tokenGenerator->generateToken());
            $em->persist($newsletter);
            $em->flush();
            $signUp = true;
            $mailer = $this->container->get('nordmind.app.custom_fos_user_mailer');
            $mailer->sendNewsletterConfirmationEmailMessage($newsletter);
            $email = $newsletter->getEmail();
        }

        return $this->render('nordmindAppBundle:Default:newsletter.html.twig', array('form' => $form->createView(), 'signUp' => isset($signUp) ? true : false, 'email' => $email));
    }

    /**
     * @Route("/newsletterConfirm/{token}", name="nordmind_app_newsletter_confirm")
     */
    public function newsletterConfirmAction(Request $request, $token)
    {
            $em = $this->getDoctrine()->getManager();
            $newsletter = $em->getRepository('nordmindAppBundle:Newsletter')->findOneBy(array('token' => $token));
            if ($newsletter) {
                $newsletter->setToken(null);
                $em->persist($newsletter);
                $em->flush();
            }

        return $this->render('nordmindAppBundle:Default:newsletterConfirm.html.twig');
    }

    /**
     * Redirect users after login based on the granted ROLE
     * @Route("/login/redirect", name="_login_redirect")
     */
    public function loginRedirectAction(Request $request)
    {

        if (!$this->get('security.authorization_checker')->isGranted('IS_AUTHENTICATED_FULLY')) {
            return $this->redirectToRoute('fos_user_security_login');
        }

        if ($this->get('security.authorization_checker')->isGranted('ROLE_ADMIN')) {
            return $this->redirectToRoute('nordmind_admin_index');
        } else if ($this->get('security.authorization_checker')->isGranted('ROLE_ARTIST')) {
            return $this->redirectToRoute('nordmind_artist_work');
        } else if ($this->get('security.authorization_checker')->isGranted('ROLE_CLIENT')) {
            return $this->redirectToRoute('nordmind_client_index');
        } else {
            return $this->redirectToRoute('fos_user_security_login');
        }
    }

    /**
     * @Route("/getTypeByRole", name="nordmind_app_user_type")
     */
    public function getTypeByRole(Request $request)
    {
        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }
        if ($request->request->get('role') == 'client') {
            $types = User::getClientTypeArray();
        } else {
            $types = User::getArtistTypeArray();
        }
        foreach ($types as $key => $type) {
            $result[$key] = $type;
        }
        return new JsonResponse($result);
    }

    /**
     * @Route("/artistList", name="nordmind_app_artist_list")
     */
    public function artistListAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $search = $request->get('term');
        $users = $em->getRepository('nordmindUserBundle:User')->getAll(User::ROLE_ARTIST, $search);
        $result = [];
        foreach ($users as $user)
        {
            $item = [];
            $item['id'] = $user->getId();
            $item['value'] = $user->getFullName();
            $item['label'] = $user->getFullName();
            $result[] = $item;
        }
        return new JsonResponse($result);
    }

    /**
     * @Route("/tagList", name="nordmind_app_tag_list")
     */
    public function tagListAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $search = $request->get('term');
        $tags = $em->getRepository('nordmindArtistBundle:Tag')->getAll($search);
        $result = [];
        foreach ($tags as $tag)
        {
            $item = [];
            $item['id'] = $tag["tag"];
            $item['value'] = $tag["tag"];
            $item['label'] = $tag["tag"];
            $result[] = $item;
        }
        return new JsonResponse($result);
    }

    /**
     * @Route("/videoPlay", name="nordmind_app_video_play")
     */
    public function videoPlayAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
        $url = "https://vimeo.com/api/oembed.json?url=".$photo->getVideoUrl();
        $response = json_decode(Utility::curl($url));
        return $this->render('nordmindAppBundle:Default:videoPlay.html.twig', array('video' => $response->html
        ));
    }

    /**
     * @Route("/regulations", name="nordmind_app_regulations")
     */
    public function regulationsAction()
    {
        return $this->render('nordmindAppBundle:Default:regulations.html.twig', array());
    }

    /**
     * @Route("/cookies", name="nordmind_app_cookies")
     */
    public function cookiesAction()
    {
        return $this->render('nordmindAppBundle:Default:cookies.html.twig', array());
    }

    /**
     * @Route("/", name="nordmind_app_index")
     */
    public function indexAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photos = $em->getRepository('nordmindArtistBundle:Photo')->getMain();
        return $this->render('nordmindAppBundle:Default:index.html.twig', array('photos' => $photos));
    }

    /**
     * @Route("/changeLanguage/{_locale}", name="nordmind_app_change_language", defaults={"_locale": "en"})
     */
    public function changeLanguageAction(Request $request)
    {
        return $this->redirectToRoute('nordmind_app_index');
    }
}
