<?php

namespace nordmind\AppBundle\Entity;

use Doctrine\ORM\EntityRepository;
use nordmind\MainBundle\System;

/**
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class NewsletterRepository extends EntityRepository
{

    public function getAll($dateFrom, $dateTo)
    {
        $qb = $this->createQueryBuilder('n');
        if ($dateFrom) {
            $qb->andWhere('n.createdAt >= :dateFrom')
                    ->setParameter('dateFrom', $dateFrom." 00:00:00");
        }
        if ($dateTo) {
            $qb->andWhere('n.createdAt <= :dateTo')
                    ->setParameter('dateTo', $dateTo." 23:59:59");
        }
        $qb->orderBy('n.createdAt', 'DESC');
        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function getDayTrafficStatistics()
    {
        $analytics = $this->getEntityManager()
                ->createQuery('SELECT u FROM nordmindAnalyticsBundle:Analytics a ORDER BY u.created_at ASC')
                ->getResult();
        $daySeries = array();
        $sumSeries = array();
        $counter = 0;
        foreach ($analytics as $user) {
            $index = $user->getCreatedAt()->getTimestamp() * 1000;
            if (!isset($daySeries[$index])) {
                $daySeries[$index] = 0;
                $sumSeries[$index] = 0;
            }
            $counter++;
            $daySeries[$index] ++;
            $sumSeries[$index] = $counter;
        }
        ksort($daySeries);
        ksort($sumSeries);
        $daySeriesPoints = array();
        foreach ($daySeries as $dayNumber => $daySeriesMonthPoint) {
            $daySeriesPoints[] = array(intval($dayNumber), $daySeriesMonthPoint);
        }
        $sumSeriesPoints = array();
        foreach ($sumSeries as $dayNumber => $daySeriesMonthPoint) {
            $sumSeriesPoints[] = array(intval($dayNumber), $daySeriesMonthPoint);
        }
        return array($daySeriesPoints, $sumSeriesPoints);
    }

    public function getLastActionForUser($user)
    {
        $sql = "select a.created_at FROM analytics a WHERE a.user_id = {$user->getId()}
         ORDER BY a.created_at DESC LIMIT 1";

        $stmt = $this->getEntityManager()
                ->getConnection()
                ->prepare($sql);

        $stmt->execute();
        return $stmt->fetch();
    }

}
