<?php

namespace nordmind\AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 *
 * @ORM\Table(name="select_notification")
 * @ORM\Entity(repositoryClass="nordmind\AppBundle\Entity\NotificationRepository")
 * @Gedmo\SoftDeleteable(fieldName="deletedAt")
 */
class Notification
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    protected $updatedAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    protected $deletedAt;

    /**
     * @var integer
     *
     * @ORM\Column(name="creator_id", type="integer", nullable=true)
     */
    protected $creatorId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\UserBundle\Entity\User", inversedBy="createdNotifications")
     * @ORM\JoinColumn(name="creator_id", referencedColumnName="id")
     */
    protected $creator;

    /**
     * @var string
     *
     * @ORM\Column(name="entity", type="string", length=1024, nullable=true)
     */
    protected $entity;

    /**
     * @var string
     *
     * @ORM\Column(name="message", type="string", length=1024, nullable=true)
     */
    protected $message;

    /**
     * @var boolean
     *
     * @ORM\Column(name="entity_id", type="integer", nullable=true)
     */
    protected $entityId;

    public function __construct($creator, $message, $entity = null, $entityId = null)
    {
        $this->creator = $creator;
        $this->message = $message;
        $this->entity = $entity;
        $this->entityId = $entityId;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    function getCreatedAt()
    {
        return $this->createdAt;
    }

    function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    function getDeletedAt()
    {
        return $this->deletedAt;
    }

    function getCreatorId()
    {
        return $this->creatorId;
    }

    function getCreator()
    {
        return $this->creator;
    }

    function getEntity()
    {
        return $this->entity;
    }

    function getEntityId()
    {
        return $this->entityId;
    }

    function setCreatedAt(\DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
    }

    function setUpdatedAt(\DateTime $updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    function setDeletedAt(\DateTime $deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }

    function setCreatorId($creatorId)
    {
        $this->creatorId = $creatorId;
    }

    function setCreator($creator)
    {
        $this->creator = $creator;
    }

    function setEntity($entity)
    {
        $this->entity = $entity;
    }

    function setEntityId($entityId)
    {
        $this->entityId = $entityId;
    }
    
    function getMessage()
    {
        return $this->message;
    }

    function setMessage($message)
    {
        $this->message = $message;
    }



}
