<?php

namespace nordmind\AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Analytics
 *
 * @ORM\Table(name="select_notification_user")
 * @ORM\Entity(repositoryClass="nordmind\AppBundle\Entity\NotificationUserRepository")
 * @Gedmo\SoftDeleteable(fieldName="deletedAt")
 */
class NotificationUser
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    protected $updatedAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    protected $deletedAt;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_id", type="integer", nullable=true)
     */
    protected $userId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\UserBundle\Entity\User", inversedBy="notifications")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @var integer
     *
     * @ORM\Column(name="notification_id", type="integer", nullable=true)
     */
    protected $notificationId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\AppBundle\Entity\Notification", inversedBy="userNotifications")
     * @ORM\JoinColumn(name="notification_id", referencedColumnName="id")
     */
    protected $notification;
    
        /**
     *
     * @var boolean
     * @ORM\Column(name="seen", type="boolean")
     *
     */
    private $seen = false;

    public function __construct($notification, $user)
    {
        $this->notification = $notification;
        $this->user = $user;
        $this->seen = false;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }
    
    function getUser()
    {
        return $this->user;
    }

    function getNotification()
    {
        return $this->notification;
    }

    function getSeen()
    {
        return $this->seen;
    }

    function setUser($user)
    {
        $this->user = $user;
    }

    function setNotification($notification)
    {
        $this->notification = $notification;
    }

    function setSeen($seen)
    {
        $this->seen = $seen;
    }

    function getCreatedAt()
    {
        return $this->createdAt;
    }

    function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    function getDeletedAt()
    {
        return $this->deletedAt;
    }

    function setCreatedAt(\DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
    }

    function setUpdatedAt(\DateTime $updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    function setDeletedAt(\DateTime $deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }



}
