<?php

namespace nordmind\AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use nordmind\AppBundle\Entity\Newsletter;

class NewsletterType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
                ->add('name', TextType::class, array('required' => true, 'label' => 'Your name:'))
                ->add('email', TextType::class, array('required' => true, 'label' => 'Your email:'))

        ;
    }

    public function getName()
    {
        return 'newsletter_form';
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Newsletter::class
        ));
    }

}
