<?php

namespace nordmind\AppBundle\Mailer;

use FOS\UserBundle\Mailer\TwigSwiftMailer;
use FOS\UserBundle\Model\UserInterface;
use nordmind\AppBundle\Entity\Newsletter;
use Symfony\Component\DependencyInjection\ContainerInterface;

class nordmindMailer extends TwigSwiftMailer
{

    private $container;

    /**
     * @param Symfony\Component\DependencyInjection\ContainerInerface   $container
     */
    public function setContainer(ContainerInterface $container)
    {
        $this->container = $container;
    }

    public function sendConfirmationEmailMessage(UserInterface $user)
    {
        $template = $this->parameters['template']['confirmation'];
        $url = $this->router->generate('fos_user_registration_confirm', array('token' => $user->getConfirmationToken()), true);
        $context = array(
            'user' => $user,
            'host' => $this->parameters['request_stack']->getCurrentRequest()->getHost(),
            'confirmationUrl' => $url
        );
        $this->sendMessage($template, $context, $this->parameters['from_email']['confirmation'], $user->getEmail());
    }

    public function sendResettingEmailMessage(UserInterface $user)
    {
        $template = $this->parameters['template']['resetting'];
        $url = $this->router->generate('fos_user_resetting_reset', array('token' => $user->getConfirmationToken()), true);
        $context = array(
            'user' => $user,
            'host' => $this->parameters['request_stack']->getCurrentRequest()->getHost(),
            'confirmationUrl' => $url
        );
        $this->sendMessage($template, $context, $this->parameters['from_email']['confirmation'], $user->getEmail());
    }

    public function sendNewsletterConfirmationEmailMessage(Newsletter $newsletter)
    {
        $template = 'nordmindAppBundle:Newsletter:email.html.twig';
        $url = $this->router->generate('nordmind_app_newsletter_confirm', array('token' => $newsletter->getToken()), true);
        $context = array(
            'newsletter' => $newsletter,
            'host' => $this->parameters['request_stack']->getCurrentRequest()->getHost(),
            'confirmationUrl' => $url
        );
        $this->sendMessage($template, $context, $this->parameters['from_email']['confirmation'], $newsletter->getEmail());
    }
}

?>
