<?php

namespace nordmind\AppBundle;

class Utility
{

    public static function curl($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    public static function geocode($address)
    {
        $address = str_replace(" ", "+", $address);
        $data = self::curl("https://maps.googleapis.com/maps/api/geocode/json?address=$address&region=pl&language=pl");
        $data = json_decode($data, true);
        if ($data["status"] != "ZERO_RESULTS") {
            if ($data["results"][0]["address_components"]) {
                foreach ($data["results"][0]["address_components"] as $addressComponent) {
                    if ($addressComponent["types"][0] == "street_number") {
                        $json["street_number"] = $addressComponent["long_name"];
                    } elseif ($addressComponent["types"][0] == "route") {
                        $json["route"] = $addressComponent["long_name"];
                    } elseif (strpos($addressComponent["types"][0], "sublocality") !== false) {
                        $json["sublocality"] = $addressComponent["long_name"];
                    } elseif ($addressComponent["types"][0] == "locality") {
                        $json["locality"] = $addressComponent["long_name"];
                    } elseif ($addressComponent["types"][0] == "administrative_area_level_2") {
                        $json["administrative_area_2"] = $addressComponent["long_name"];
                    } elseif ($addressComponent["types"][0] == "administrative_area_level_1") {
                        $json["administrative_area_1"] = $addressComponent["long_name"];
                    } elseif ($addressComponent["types"][0] == "country") {
                        $json["country"] = $addressComponent["long_name"];
                    }
                }
                $json["lat"] = $data["results"][0]["geometry"]["location"]["lat"];
                $json["lng"] = $data["results"][0]["geometry"]["location"]["lng"];
                return $json;
            }
        }
        return null;
    }

    public static function getPaging($offset, $limit, $count)
    {
        $lastPage = ceil($count / $limit);
        $counter = 1;
        $i = $offset - 2;
        $pageArray = array();
        while ($counter <= 5 && $i <= $lastPage) {
            if ($i > 0) {
                $pageArray["paging"][] = $i;
                $counter++;
            }
            $i++;
        }
        $pageArray["offset"] = $offset;
        $pageArray["limit"] = $limit;
        $pageArray["lastPage"] = $lastPage;
        return $pageArray;
    }

    public static function getMethodValues($objects, $method, $withoutIndex = false)
    {
        $values = array();
        $counter = 0;
        foreach ($objects as $object) {
            $v = call_user_func(array($object, $method));

            if ($withoutIndex) {
                $counter++;
                $values[$counter] = $v;
            } else
                $values[$v] = $v;
        }

        return $values;
    }

    /**
     * @param type   $objects
     * @param string $method
     * @param type   $params
     * @param bool   $stackArrays       - służy do zbierania pod jednym kluczem w tablicy wszystkich obiektów pasujących, false sprawi, że tylko ostatni znajdzie się pod kluczem
     * @param bool   $alwaysReturnArray
     *
     * @return type
     */
    public static function getMethodArray($objects, $method, $params = array(), $stackArrays = true, $alwaysReturnArray = false)
    {
        $ids = array();
        if ($objects) {
            foreach ($objects as $object) {
                $key = call_user_func_array(array($object, $method), $params);
                //castowanie klucza na stringa jeśli nie jest intem lub stringiem
                if (!is_int($key) && !is_string($key)) {
                    $key = (string) $key;
                }
                if ((isset($ids[$key]) && $stackArrays) || $alwaysReturnArray) {
                    if ((isset($ids[$key]) && !is_array($ids[$key])) && !$alwaysReturnArray) {
                        //przepisanie pierwszego do tablicy
                        $tmp = $ids[$key];
                        unset($ids[$key]);
                        $ids[$key][] = $tmp;
                    }
                    $ids[$key][] = $object;
                } else {
                    $ids[$key] = $object;
                }
            }
        }

        return $ids;
    }

    public static function getKeyValueMethodArray($objects, $keyMethod, $valueMethod)
    {
        $ids = array();
        if ($objects) {
            foreach ($objects as $object) {
                $key = call_user_func(array($object, $keyMethod));
                $value = null;
                if (is_array($valueMethod)) {
                    foreach ($valueMethod as $vm) {
                        $value[] = call_user_func(array($object, $vm));
                    }
                } else {
                    $value = call_user_func(array($object, $valueMethod));
                }
                if (array_key_exists($key, $ids)) {
                    if (!is_array($ids[$key])) {
                        //przepisanie pierwszego do tablicy
                        $tmp = $ids[$key];
                        unset($ids[$key]);
                        $ids[$key][] = $tmp;
                    }
                    $ids[$key][] = $value;
                } else {
                    $ids[$key] = $value;
                }
            }
        }
        return $ids;
    }

    public static function retrieveNavigationFilter($request, $filterName, $requestName = null, $defaultValue = null, $forcedModuleName = null)
    {
        $requestName = $requestName ? $requestName : $filterName;
        if ($request->get($requestName)) {
            Utility::setNavigationFilter($request, $filterName, $request->get($requestName), $forcedModuleName);
        }
        return Utility::getNavigationFilter($request, $filterName, $defaultValue, $forcedModuleName);
    }

    public static function getNavigationFilter($request, $filterName, $defaultValue = null, $forcedModuleName = null)
    {
        if ($request->get("clear_all_filters")) {
            return $defaultValue;
        }
        $moduleName = $forcedModuleName;
        $filtersTable = $request->getSession()->get($moduleName . "_filters");
        return isset($filtersTable[$filterName]) ? $filtersTable[$filterName] : $defaultValue;
    }

    public static function setNavigationFilter($request, $filterName, $value = null, $forcedModuleName = null)
    {
        if ($request->get("clear_all_filters")) {
            return;
        }
        if ($value == "null") {
            $value = null;
        }
        $moduleName = $forcedModuleName;
        $filtersTable = $request->getSession()->get($moduleName . "_filters", array());
        $filtersTable[$filterName] = $value;
        $request->getSession()->set($moduleName . "_filters", $filtersTable);
    }

}
