<?php

namespace nordmind\ArtistBundle\Controller;

use nordmind\ArtistBundle\Entity\Favorite;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use nordmind\UserBundle\Entity\User;
use nordmind\ArtistBundle\Entity\Photo;
use Symfony\Component\HttpFoundation\JsonResponse;
use nordmind\AppBundle\Utility;
use nordmind\ArtistBundle\Entity\Category;
use nordmind\ArtistBundle\Entity\Theme;
use nordmind\ArtistBundle\Entity\Tag;
use Symfony\Component\HttpFoundation\RedirectResponse;

class DefaultController extends Controller
{

//    /**
//     * @Route("/", name="nordmind_artist_index")
//     * @Route("/profile/{slug}", name="nordmind_artist_profile_index")
//     */
//    public function indexAction(User $user = null)
//    {
//        $em = $this->getDoctrine()->getManager();
//        $user = $user ?? $this->getUser();
//        $categories = $user->getCategories();
//        $photos = $user->getPhotos();
//        if (!$photos)
//        {
//            if ($user == $this->getUser()) {
//                return new RedirectResponse($this->generateUrl('nordmind_artist_work'));
//            }
//            else
//            {
//                return new RedirectResponse($this->generateUrl('nordmind_app_index'));
//            }
//        }
//        $em = $this->getDoctrine()->getManager();
//        return $this->render('nordmindArtistBundle:Default:index.html.twig', array('user' => $user, 'photos' => $photos, 'categories' => $categories));
//    }

    /**
     * @Route("/subscription", name="nordmind_artist_subscription")
     */
    public function subscriptionAction(Request $request)
    {
        $user = $this->getUser();
        return $this->render('nordmindArtistBundle:Default:subscription.html.twig', array('user' => $user));
    }

//    /**
//     * @Route("/indexPhoto", name="nordmind_artist_index_photo")
//     */
//    public function indexPhotoAction()
//    {
//        $em = $this->getDoctrine()->getManager();
//        $user = $this->getUser();
//        $photos = $user->getPhotos();
//        $em = $this->getDoctrine()->getManager();
//        return $this->render('nordmindArtistBundle:Default:indexPhoto.html.twig', array('photos' => $photos));
//    }

    /**
     * @Route("/work", name="nordmind_artist_work")
     */
    public function workAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $categories = $user->getCategories();
        $photos = $user->getPhotos();
        $cover = $user->getCover();
        return $this->render('nordmindArtistBundle:Default:work.html.twig', array('photos' => $photos, 'user' => $user, 'categories' => $categories, 'filters' => false));
    }

    /**
     * @Route("/workPhoto", name="nordmind_artist_work_photo")
     */
    public function workPhotoAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $photos = $user->getPhotos();
        return $this->render('nordmindArtistBundle:Default:workPhoto.html.twig', array('photos' => $photos));
    }

    /**
     * @Route("/afterUpload", name="nordmind_artist_after_upload")
     */
    public function afterUploadAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $photos = $em->getRepository('nordmindArtistBundle:Photo')->getForAfterUpload($user->getId());
        $categories = Category::getAll();
        $themes = Theme::getAll();
        return $this->render('nordmindArtistBundle:Default:afterUpload.html.twig', array('photos' => $photos,
                    'categories' => $categories,
                    'themes' => $themes
        ));
    }

    /**
     * @Route("/upload", name="nordmind_artist_upload")
     */
    public function uploadAction(Request $request)
    {
        $user = $this->getUser();
        $file = $request->files->get('file');
        if ($file) {
            $fileName = md5(uniqid()) . '.jpg';
            $path = $file->getRealPath();
            if (is_file($path) && mime_content_type($path) == 'image/png') {
                $image = \imagecreatefrompng($path);
            } else {
                $image = \imagecreatefromjpeg($path);
            }
            $dir = $this->container->getParameter('kernel.root_dir') . "/../public_html/uploads/images";
            if ($image) {
                \imagejpeg($image, $dir . "/" . $fileName, 85);
            }
            $file->move($dir, $fileName);
            $em = $this->getDoctrine()->getManager();
            $photo = new Photo();
            $photo->setUser($user);
            $photo->setPath($fileName);
            $em->persist($photo);
            if (!$user->getCover())
            {
                $photo->setIsCover(true);
                $user->setHasLogo(true);
                $em->persist($user);
            }
            $em->flush();
            $response = new JsonResponse(array('message' => 'Photo added', 'callback' => "c_reloadWindow()"));
        }
        else
        {
            $response = new JsonResponse(array('message' => 'There was an error', 'callback' => ""));
        }
        return $response;
    }

    /**
     * @Route("/savePhoto", name="nordmind_artist_photo_save")
     */
    public function photoSaveAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
        if ($request->get('categories')) {
            $photo->setCategories($request->get('categories'));
        }
        if ($request->get('themes')) {
            $photo->setThemes($request->get('themes'));
        }
        if ($request->get('tags')) {
            $photo->setTags($request->get('tags'));
        }
        $em->persist($photo);
        $em->flush();
        $response = new JsonResponse(array('message' => "Changes have been saved"));
        return $response;
    }

    /**
     * @Route("/saveVideo", name="nordmind_artist_video_save")
     */
    public function videoSaveAction(Request $request)
    {
        $dir = $this->container->getParameter('kernel.root_dir') . "/../public_html/uploads/images/";
        $url = "https://vimeo.com/api/oembed.json?url=".$request->get('url');
        $response = json_decode(Utility::curl($url));
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $photo = new Photo();
        $filename = md5(uniqid()).".jpg";
        $photo->setUser($user);
        $photo->setIsVideo(true);
        $photo->setVideoUrl($request->get('url'));
        $photo->setPath($filename);
        $em->persist($photo);
        $em->flush();
        $image = imagecreatefromstring(file_get_contents($response->thumbnail_url_with_play_button));
        if ($image !== false) {
            imagejpeg($image, $dir.$filename);
            $user->setHasLogo(true);
            $em->persist($user);
            $em->flush();
            $response = new JsonResponse(array('message' => "Video has been saved", 'callback' => 'c_reloadWindow()', 'id' => $photo->getId()));
        }else {
            $response = new JsonResponse(array('message' => "An error occured"));
        }
        return $response;
    }

    /**
     * @Route("/editPhoto", name="nordmind_artist_photo_edit")
     */
    public function photoEditAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
        $categories = Category::getAll();
        $themes = Theme::getAll();
        return $this->render('nordmindArtistBundle:Default:editPhoto.html.twig', array('photo' => $photo,
                    'categories' => $categories,
                    'themes' => $themes
        ));
    }

    /**
     * @Route("/coverPhoto", name="nordmind_artist_photo_cover")
     */
    public function photoCoverAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
        return $this->render('nordmindArtistBundle:Default:coverPhoto.html.twig', array('photo' => $photo
        ));
    }

    /**
     * @Route("/coverPhotoSave", name="nordmind_artist_photo_cover_save")
     */
    public function photoCoverSaveAction(Request $request)
    {
        if ($request->isMethod('POST')) {
            $em = $this->getDoctrine()->getManager();
            $user = $this->get('security.context')->getToken()->getUser();
            $cover = $user->getCover();
            if ($cover)
            {
                $cover->setIsCover(false);
            }
            $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
            $photo->setIsCover(true);
            $user->setHasLogo(true);
            if ($cover)
            {
                $em->persist($cover);
            }
            $em->persist($photo);
            $em->persist($user);
            $em->flush();
            $callBackFunction = 'c_reloadWindow()';
            $response = new JsonResponse(array('message' => "Your cover is ready.", 'callback' => $callBackFunction));
            return $response;
        }
    }

    /**
     * @Route("/photoDelete/{id}", name="nordmind_artist_photo_delete", requirements={"id"="\d+"})
     */
    public function photoDeleteAction($id)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($id);
        $em->remove($photo);
        $em->flush();
        $callBackFunction = 'c_reloadWindow()'; //$callback == 'table' ? "c_refreshEditable({$id})" : "c_refreshWall({$id})";
        $response = new JsonResponse(array('message' => "Photo deleted", 'callback' => $callBackFunction));
        return $response;
    }

    /**
     * @Route("/photoFavoriteAdd", name="nordmind_artist_photo_favorite_add")
     */
    public function photoFavoriteAddAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
        $favorite = $em->getRepository('nordmindArtistBundle:Favorite')->findBy(array('user' => $this->getUser(), 'photo' => $photo));
        if (!$favorite) {
            $favorite = new Favorite($this->getUser(), $photo);
            $em->persist($favorite);
            $em->flush();
        }
        $response = new JsonResponse(array('message' => "Photo added to favorites"));
        return $response;
    }

    /**
     * @Route("/photoFavoriteRemove", name="nordmind_artist_photo_favorite_remove")
     */
    public function photoFavoriteRemoveAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $photo = $em->getRepository('nordmindArtistBundle:Photo')->find($request->get('id'));
        $favorite = $em->getRepository('nordmindArtistBundle:Favorite')->findOneBy(array('user' => $this->getUser(), 'photo' => $photo));
        if ($favorite) {
            $em->remove($favorite);
            $em->flush();
        }
        $response = new JsonResponse(array('message' => "Photo removed from favorites"));
        return $response;
    }

    /**
     * @Route("/photoSort", name="nordmind_artist_photo_sort")
     */
    public function photoSortAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $ids = $request->get('ids');
        $user = $this->getUser();
        $photos = Utility::getMethodArray($user->getPhotos(), "getId");

        foreach ($ids as $i => $id) {
            $photos[$id]->setPosition($i + 1);
            $em->persist($photos[$id]);
        }
        $em->flush();
        $callBackFunction = 'c_reloadWindow()'; //$callback == 'table' ? "c_refreshEditable({$id})" : "c_refreshWall({$id})";
        $response = new JsonResponse(array('message' => "Positions saved", 'callback' => $callBackFunction));
        return $response;
    }

}
