<?php

namespace nordmind\ArtistBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 *
 * @ORM\Table(name="select_category")
 * @ORM\Entity()
 */
class Category
{
    const ADVERTISTING = 'ADVERTISING';
    const ARCHITECTURE = 'ARCHITECTURE';
    const BEAUTY = 'BEAUTY';
    const CGI = 'CGI';
    const DESIGN = 'DESGIN';
    const DRONE = 'DRONE';
    const EDITORIAL = 'EDITORIAL';
    const EVENTS = 'EVENTS';
    const FASHION = 'FASHION';
    const FINE_ART = 'FINE ART';
    const FOOD = 'FOOD';
    const INTERIORS = 'INTERIORS';
    const LANDSCAPE = 'LANDSCAPE';
    const MOTO = 'MOTO';
    const NATURE = 'NATURE';
    const NUDE = 'NUDE';
    const PACKSHOTS = 'PACKSHOTS';
    const PHOTOJOURNALISM = 'PHOTOJOURNALISM';
    const PORTRAIT = 'PORTRAIT';
    const SPORT = 'SPORT';
    const STILL_LIFE = 'STILL LIFE';
    const STREET = 'STREET';
    const TRAVEL = 'TRAVEL';
    
        /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    
        /**
     * @ORM\ManyToOne(targetEntity="nordmind\ArtistBundle\Entity\Photo", inversedBy="categories")
     * @ORM\JoinColumn(name="photo_id", referencedColumnName="id")
     */
    protected $photo;
    
     /**
     * @var string
     *
     * @ORM\Column(name="category", type="string", length=255, nullable=false)
     */
    private $category;
    
    public function __construct($photo, $category)
    {
        $this->photo = $photo;
        $this->category = $category;
    }

    public static function getAll()
    {
        return array(
            self::ADVERTISTING => self::ADVERTISTING,
            self::ARCHITECTURE => self::ARCHITECTURE,
            self::BEAUTY => self::BEAUTY,
            self::CGI => self::CGI,
            self::DRONE => self::DRONE,
            self::EDITORIAL => self::EDITORIAL,
            self::EVENTS => self::EVENTS,
            self::FASHION => self::FASHION,
            self::FINE_ART => self::FINE_ART,
            self::FOOD => self::FOOD,
            self::INTERIORS => self::INTERIORS,
            self::LANDSCAPE => self::LANDSCAPE,
            self::MOTO => self::MOTO,
            self::NATURE => self::NATURE,
            self::NUDE => self::NUDE,
            self::PACKSHOTS => self::PACKSHOTS,
            self::PHOTOJOURNALISM => self::PHOTOJOURNALISM,
            self::PORTRAIT => self::PORTRAIT,
            self::SPORT => self::SPORT,
            self::STILL_LIFE => self::STILL_LIFE,
            self::STREET => self::STREET,
            self::TRAVEL => self::TRAVEL
        );
    }

    public static function getByKey($key)
    {
        $array = self::getAll();
        return $array[$key];
    }

    /**
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
}
