<?php

namespace nordmind\ArtistBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use \Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Criteria;
use Symfony\Component\HttpFoundation\File\UploadedFile;

/**
 *
 * @ORM\Table(name="select_photo")
 * @ORM\Entity(repositoryClass="nordmind\ArtistBundle\Entity\PhotoRepository")
 * @Gedmo\SoftDeleteable(fieldName="deletedAt")
 */
class Photo
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    protected $updatedAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    protected $deletedAt;

    /**
     * @var string
     *
     * @ORM\Column(name="path", type="string", length=255, nullable=true)
     */
    private $path;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     */
    private $name;

    /**
     * @var categories
     *
     * @ORM\OneToMany(targetEntity="nordmind\ArtistBundle\Entity\Category", mappedBy="photo", cascade={"persist"}, orphanRemoval=true)
     */
    private $categories;

    /**
     * @var themes
     *
     * @ORM\OneToMany(targetEntity="nordmind\ArtistBundle\Entity\Theme", mappedBy="photo", cascade={"persist"}, orphanRemoval=true)
     */
    private $themes;

    /**
     * @var tags
     *
     * @ORM\OneToMany(targetEntity="nordmind\ArtistBundle\Entity\Tag", mappedBy="photo", cascade={"persist"}, orphanRemoval=true)
     */
    private $tags;

    /**
     * @var integer
     *
     * @ORM\Column(name="position", type="integer", nullable=true)
     */
    private $position;

    /**
     * @var integer
     *
     * @ORM\Column(name="size", type="integer", nullable=true)
     */
    private $size;

    /**
     * @var UploadedFile
     */
    private $file;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_id", type="integer", nullable=true)
     */
    protected $userId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\UserBundle\Entity\User", inversedBy="photos")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @var Favorite
     *
     * @ORM\OneToMany(targetEntity="nordmind\ArtistBundle\Entity\Favorite", mappedBy="photo", cascade={"persist"}, orphanRemoval=true)
     */
    private $favorites;

    /**
     * @var MainPhoto
     *
     * @ORM\OneToOne(targetEntity="nordmind\AppBundle\Entity\MainPhoto", mappedBy="photo", cascade={"persist"}, orphanRemoval=true)
     */
    private $mainPhoto;

    /**
     *
     * @var boolean
     * @ORM\Column(name="is_cover", type="boolean")
     *
     */
    private $isCover = false;

    /**
     *
     * @var boolean
     * @ORM\Column(name="is_video", type="boolean")
     *
     */
    private $isVideo = false;

    /**
     * @var string
     *
     * @ORM\Column(name="video_url", type="string", length=255, nullable=true)
     */
    private $videoUrl;

    public function __construct()
    {
        $this->categories = new ArrayCollection();
        $this->themes = new ArrayCollection();
        $this->tags =new ArrayCollection();
        $this->favorites =new ArrayCollection();
    }

    function getId()
    {
        return $this->id;
    }

    function getCreatedAt()
    {
        return $this->createdAt;
    }

    function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    function getDeletedAt()
    {
        return $this->deletedAt;
    }

    function getPath()
    {
        return $this->path;
    }

    function getName()
    {
        return $this->name;
    }

    function getSize()
    {
        return $this->size;
    }

    function getFile()
    {
        return $this->file;
    }

    function getUserId()
    {
        return $this->userId;
    }

    function getUser()
    {
        return $this->user;
    }

    function setId($id)
    {
        $this->id = $id;
    }

    function setCreatedAt(\DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
    }

    function setUpdatedAt(\DateTime $updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    function setDeletedAt(\DateTime $deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }

    function setPath($path)
    {
        $this->path = $path;
    }

    function setName($name)
    {
        $this->name = $name;
    }

    function setSize($size)
    {
        $this->size = $size;
    }

    function setFile(UploadedFile $file)
    {
        $this->file = $file;
    }

    function setUserId($userId)
    {
        $this->userId = $userId;
    }

    function setUser($user)
    {
        $this->user = $user;
    }

    function getPosition()
    {
        return $this->position;
    }

    function setPosition($position)
    {
        $this->position = $position;
    }

    function setCategories($categories)
    {
        foreach ($this->categories as $category) {
            $this->categories->removeElement($category);
        }
        foreach ($categories as $category) {
            $this->categories->add(new Category($this, $category));
        }
    }

    function setThemes($themes)
    {
        foreach ($this->themes as $theme) {
            $this->themes->removeElement($theme);
        }
        foreach ($themes as $theme) {
            $this->themes->add(new Theme($this, $theme));
        }
    }

    function setTags($tags)
    {
        foreach ($this->tags as $tag) {
            $this->tags->removeElement($tag);
        }
        $tags = explode(",", $tags);
        foreach ($tags as $tag)
        {
            $this->tags->add(new Tag($this, $tag));
        }
    }

    function getCategories()
    {
        return $this->categories;
    }

    /**
     * @return themes
     */
    public function getThemes()
    {
        return $this->themes;
    }

    function hasCategory($category)
    {
        $criteria = Criteria::create()
                ->andWhere(Criteria::expr()->contains('category', $category));
        return count($this->categories->matching($criteria)) > 0 ? true : false;
    }

    function hasTheme($theme)
    {
        $criteria = Criteria::create()
                ->andWhere(Criteria::expr()->contains('theme', $theme));
        return count($this->themes->matching($criteria)) > 0 ? true : false;
    }

    function printCategories()
    {
        $categories = $this->categories;
        $data = [];
        //TODO change to keys
        foreach ($categories as $category) {
            $data[] = $category->getCategory();
        }
        return implode($data, " ");
    }

    function printThemes()
    {
        $themes = $this->themes;
        $data = [];
        //TODO change to keys
        foreach ($themes as $theme) {
            $data[] = $theme->getTheme();
        }
        return implode($data, " ");
    }

    function printKeyCategories()
    {
        $categories = $this->categories;
        $data = [];
        //TODO change to keys
        foreach ($categories as $category) {
            $data[] = str_replace(' ', '_', $category->getCategory());
        }
        return implode($data, " ");
    }

    function printTags()
    {
        $tags = $this->tags;
        $data = [];
        foreach ($tags as $tag) {
            $data[] = $tag->getTag();
        }
        return implode($data, ",");
    }

    public function isCompleted()
    {
        if (count($this->getCategories()))
        {
            return true;
        }
        return false;
    }

    /**
     * @return bool
     */
    public function isCover()
    {
        return $this->isCover;
    }

    /**
     * @param bool $isCover
     */
    public function setIsCover($isCover)
    {
        $this->isCover = $isCover;
    }

    /**
     * @return bool
     */
    public function isVideo()
    {
        return $this->isVideo;
    }

    /**
     * @param bool $isVideo
     */
    public function setIsVideo($isVideo)
    {
        $this->isVideo = $isVideo;
    }

    /**
     * @return string
     */
    public function getVideoUrl()
    {
        return $this->videoUrl;
    }

    /**
     * @param string $videoUrl
     */
    public function setVideoUrl($videoUrl)
    {
        $this->videoUrl = $videoUrl;
    }

    public function getFullPath()
    {
        return "/uploads/images/". $this->getPath();
    }

    /**
     * @return tags
     */
    public function getTags()
    {
        return $this->tags;
    }


}
