<?php

namespace nordmind\ArtistBundle\Entity;

use Doctrine\ORM\EntityRepository;

class PhotoRepository extends EntityRepository
{

    const PHOTOS_PER_PAGE = 20;

    public function getForAfterUpload($userId)
    {
        $qb = $this->createQueryBuilder('o')->select('p, c, t, ta')
            ->from('nordmindArtistBundle:Photo', 'p');
        $qb->leftJoin('p.categories', 'c');
        $qb->leftJoin('p.themes', 't');
        $qb->leftJoin('p.tags', 'ta');
        $qb->andWhere('p.user = :user')
            ->setParameter('user', $userId);
        $qb->orderBy('p.createdAt', 'DESC');
        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function getReview($searchCategories)
    {
        $qb = $this->createQueryBuilder('p');
        $qb->leftJoin('p.categories', 'c');
        $qb->andWhere('c.category IN (:categories)')
            ->setParameter('categories', $searchCategories);
        $qb->orderBy('p.createdAt', 'DESC');
        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function search($searchProfession, $searchArtist, $searchTag, $searchCategories, $searchThemes, $page, $sortBy = 'date')
    {
        $qb = $this->createQueryBuilder('p');
        if ($searchProfession) {
            if ($searchProfession == 'videographers') {
                $qb->andWhere('p.isVideo = true');
            } else {
                $qb->andWhere('p.isVideo = false');
            }
        }
        if ($searchCategories) {
            $qb->leftJoin('p.categories', 'c');
            $qb->andWhere('c.category IN (:categories)')
                ->setParameter('categories', $searchCategories);
        }
        if ($searchTag) {
            $qb->leftJoin('p.tags', 'ta');
            $qb->andWhere('ta.tag = :tag')
                ->setParameter('tag', $searchTag);
        }
        if ($searchArtist) {
            $qb->leftJoin('p.user', 'u');
            $qb->andWhere('CONCAT(u.name, \' \',u.lastName) LIKE :userId')
                ->setParameter('userId', $searchArtist);
        }
        if ($sortBy == 'name') {
            $qb->leftJoin('p.user', 'u');
            $qb->orderBy('u.lastName', 'DESC');
        } else {
            $qb->orderBy('p.createdAt', 'DESC');
        }
        $qb->setMaxResults(self::PHOTOS_PER_PAGE)->setFirstResult(($page - 1) * self::PHOTOS_PER_PAGE);
        $query = $qb->getQuery();
        return $query->getResult();
    }

    public function getMain()
    {
        $qb = $this->createQueryBuilder('p');
        $qb->join('p.mainPhoto', 'pm');
        $qb->orderBy('pm.position', 'ASC');
        $query = $qb->getQuery();
        return $query->getResult();
    }

}
