<?php

namespace nordmind\ArtistBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 *
 * @ORM\Table(name="select_tag")
 * @ORM\Entity(repositoryClass="nordmind\ArtistBundle\Entity\TagRepository")
 */
class Tag
{
    
        /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    
        /**
     * @ORM\ManyToOne(targetEntity="nordmind\ArtistBundle\Entity\Photo", inversedBy="categories")
     * @ORM\JoinColumn(name="photo_id", referencedColumnName="id")
     */
    protected $photo;
    
     /**
     * @var string
     *
     * @ORM\Column(name="tag", type="string", length=255, nullable=false)
     */
    private $tag;
    
    public function __construct($photo, $tag)
    {
        $this->photo = $photo;
        $this->tag = $tag;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    
    function getTag()
    {
        return $this->tag;
    }
}
