<?php

namespace nordmind\ArtistBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 *
 * @ORM\Table(name="select_theme")
 * @ORM\Entity()
 */
class Theme
{

    const ANIMALS = "ANIMALS";
    const CELEBRITIES = "CELEBRITIES";
    const COSMETICS = "COSMETICS";
    const DRINKS = "DRINKS";
    const FOOD = "FOOD";
    const INDUSTRIAL = "INDUSTRIAL";
    const INTERIOR = "INTERIOR";
    const JEWELLERY = "JEWELLERY";
    const KIDS = "KIDS";
    const LIFESTYLE = "LIFESTYLE";
    const LINGERIE = "LINGERIE";
    const LIQUIDS = "LIQUIDS";
    const PEOPLE = "PEOPLE";
    const TECHNOLOGY = "TECHNOLOGY";
    const VEHICLES = "VEHICLES";

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\ArtistBundle\Entity\Photo", inversedBy="categories")
     * @ORM\JoinColumn(name="photo_id", referencedColumnName="id")
     */
    protected $photo;

    /**
     * @var string
     *
     * @ORM\Column(name="theme", type="string", length=255, nullable=false)
     */
    private $theme;

    public function __construct($photo, $theme)
    {
        $this->photo = $photo;
        $this->theme = $theme;
    }

    public static function getAll()
    {
        return array(
            self::ANIMALS => "ANIMALS",
            self::CELEBRITIES => "CELEBRITIES",
            self::COSMETICS => "COSMETICS",
            self::DRINKS => "DRINKS",
            self::FOOD => "FOOD",
            self::INDUSTRIAL => "INDUSTRIAL",
            self::INTERIOR => "INTERIOR",
            self::JEWELLERY => "JEWELLERY",
            self::KIDS => "KIDS",
            self::LIFESTYLE => "LIFESTYLE",
            self::LINGERIE => "LINGERIE",
            self::LIQUIDS => "LIQUIDS",
            self::PEOPLE => "PEOPLE",
            self::TECHNOLOGY => "TECHNOLOGY",
            self::VEHICLES => "VEHICLES"
        );
    }

    /**
     * @return string
     */
    public function getTheme()
    {
        return $this->theme;
    }

    

}
