<?php

namespace nordmind\EventBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use nordmind\EventBundle\Entity\Event;
use nordmind\EventBundle\Form\EventStepOneType;
use nordmind\EventBundle\Form\EventStepTwoType;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\JsonResponse;

class DefaultController extends Controller
{

    /**
     * @Route("/", name="nordmind_event_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        $events = $em->getRepository('nordmindEventBundle:Event')->getAll(new \DateTime());
        return $this->render('nordmindEventBundle:Default:index.html.twig', array('events' => $events, 'active' => 'actual'));
    }

    /**
     * @Route("/closed", name="nordmind_event_closed")
     */
    public function closedAction()
    {
        $em = $this->getDoctrine()->getManager();
        $events = $em->getRepository('nordmindEventBundle:Event')->getAll(new \DateTime(), "<");
        return $this->render('nordmindEventBundle:Default:index.html.twig', array('events' => $events, 'active' => 'closed'));
    }

    /**
     * @Route("/create/{id}/{step}", name="nordmind_event_create", requirements={"step"="\d+"})
     */
    public function createAction(Request $request, Event $event = null, $step = 'new')
    {
        if ($step == 'new') {
            $event = new Event();
            $formOne = $this->createForm(EventStepOneType::class, $event);
        }
        if ($step == 1 || $step == 'new') {
            $em = $this->getDoctrine()->getManager();
            $event->setContactEmail($this->get('session')->get('issuer_email'));
            $event->setContactPhone($this->get('session')->get('issuer_phone'));
            $formOne = $this->createForm(EventStepOneType::class, $event);
            $formTwo = $this->createForm(EventStepTwoType::class, $event);
            $formOne->handleRequest($request);
            if ($formOne->isSubmitted() && $formOne->isValid()) {
                $em = $this->getDoctrine()->getManager();
                $event = $formOne->getData();
                $nextStep = $event->getStep() > 2 ? 1 : $event->getStep() + 1;
                $event->increaseStep(1);
                $em->persist($event);
                $em->flush();

                return $this->redirectToRoute('nordmind_event_create', array('step' => $nextStep, 'id' => $event->getId()));
            }
        } else if ($step == 2) {
            $em = $this->getDoctrine()->getManager();
            $formOne = $this->createForm(EventStepOneType::class, $event);
            $formTwo = $this->createForm(EventStepTwoType::class, $event);
            $formTwo->handleRequest($request);
            if ($formTwo->isSubmitted() && $formTwo->isValid()) {
                $em = $this->getDoctrine()->getManager();
                $event = $formTwo->getData();
                $nextStep = $event->getStep() > 2 ? 2 : $event->getStep() + 1;
                $event->increaseStep(2);
                $em->persist($event);
                $em->flush();
                return $this->redirectToRoute('nordmind_event_create', array('step' => $nextStep, 'id' => $event->getId()));
            }
        } else if ($step == 3) {
            $em = $this->getDoctrine()->getManager();
            $formOne = $this->createForm(EventStepOneType::class, $event);
            $formTwo = $this->createForm(EventStepTwoType::class, $event);
        }

        return $this->render('nordmindEventBundle:Default:create.html.twig', array('step' => $step, 'event' => $event, 'formOne' => $formOne->createView(), 'formTwo' => isset($formTwo) ? $formTwo->createView() : null));
    }

    /**
     * @Route("/logoUpdate/{id}", name="nordmind_event_logo_update")
     * @Method({"POST"})
     */
    public function logoUpdateAction(Request $request, Event $event)
    {
        if ($request->isMethod('POST')) {
            $em = $this->getDoctrine()->getManager();
            $rootDir = $this->container->getParameter('kernel.root_dir') . "/../web/uploads/images/event/";
            $data = $request->request->get('image-data');
            $exp = explode(',', $data);
            $base64 = array_pop($exp);
            $data = base64_decode($base64);
            $file = $rootDir . "{$event->getId()}.jpg";

            $im = imagecreatefromstring($data);
            if ($im !== false) {
                imagejpeg($im, $file);
                $event->setHasLogo(true);
                $em->persist($event);
                $em->flush();
                $message = "Zapisano zmiany";
            } else {
                $message = "Wystąpił błąd";
            }
            $request->getSession()
                    ->getFlashBag()
                    ->add('success', $message);
            return $this->redirect(
                            $this->getRequest()
                                    ->headers
                                    ->get('referer'));
        }
        return $this->render('nordmindEventBundle:Default:create.html.twig', array());
    }

    /**
     * @Route("/delete/{id}", name="nordmind_event_delete", requirements={"id"="\d+"})
     */
    public function deleteAction(Event $event)
    {
        $em = $this->getDoctrine()->getManager();
        $em->remove($event);
        $em->flush();
        $response = new JsonResponse(array('message' => "Wydarzenie zostało usunięte.", 'callback' => "c_reloadWindow()"));
        return $response;
    }
    
        /**
     * @Route("/show/{id}", name="nordmind_event_show", requirements={"id"="\d+"})
     */
    public function showAction(Event $event)
    {
        return $this->render('nordmindEventBundle:Default:show.html.twig', array('event' => $event));
    }

}
