<?php

namespace nordmind\EventBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use nordmind\EventBundle\Entity\Event;
use nordmind\EventBundle\Entity\Group;
use nordmind\EventBundle\Form\EventStepOneType;
use nordmind\EventBundle\Form\EventStepTwoType;
use nordmind\EventBundle\Form\GroupType;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\JsonResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

class GroupController extends Controller
{

    /**
     * @Route("/{id}/groups", name="nordmind_group_index")
     */
    public function indexAction(Request $request, Event $event)
    {
        $em = $this->getDoctrine()->getManager();
        $groups = $em->getRepository('nordmindEventBundle:Group')->findAll();
        return $this->render('nordmindEventBundle:Group:index.html.twig', array('event' => $event, 'groups' => $groups));
    }

    /**
     * @Route("{id}/groups/delete/{groupId}", name="nordmind_group_delete", requirements={"id"="\d+"})
     */
    public function deleteAction(Event $event, $groupId)
    {
        $em = $this->getDoctrine()->getManager();
        $em->remove($event);
        $em->flush();
        $response = new JsonResponse(array('message' => "Grupa została usunięta", 'callback' => "c_reloadWindow()"));
        return $response;
    }

    /**
     * @Route("{id}/groups/show/{groupId}", name="nordmind_group_show", requirements={"id"="\d+"})
     */
    public function showAction(Event $event, $groupId)
    {
        $em = $this->getDoctrine()->getManager();
        $group = $em->getRepository('nordmindEventBundle:Group')->find($groupId);
        return $this->render('nordmindEventBundle:Group:show.html.twig', array('event' => $event, 'group' => $group));
    }

    /**
     * @Route("{id}/groups/create/{groupId}", name="nordmind_group_create")
     */
    public function createAction(Request $request, Event $event, $groupId = null)
    {
        $em = $this->getDoctrine()->getManager();
        if (!$groupId) {
            $group = new Group();
            $group->setEvent($event);
        }
        else
        {
            $group = $em->getRepository('nordmindEventBundle:Group')->find($groupId);
        }
        $form = $this->createForm(GroupType::class, $group, array(
            'action' => $this->generateUrl('nordmind_group_create', array("id" => $event->getId(), "groupId" => $group->getId())),
        ));
        $form->handleRequest($request);
        
        if ($form->isSubmitted() && $form->isValid()) {
            
            $data = $form->getData();
            $em->persist($data);
            $em->flush();
            $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Zapisano zmiany.')
            ;
            return $this->redirectToRoute('nordmind_group_index', array('id' => $event->getId()));
        }

        return $this->render('nordmindEventBundle:Group:create.html.twig', array('form' => $form->createView(), 'event' => $event, 'group' => $group));
    }

}
