<?php

namespace nordmind\EventBundle\Entity;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @Gedmo\SoftDeleteable(fieldName="deletedAt", timeAware=false, hardDelete=false)
 * @ORM\Entity(repositoryClass="nordmind\EventBundle\Entity\EventRepository")
 * @ORM\Table(name="select_event")
 */
class Event
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     *
     * @var string
     * @ORM\Column(name="name", type="string", length=512, nullable=false)
     * @Assert\NotBlank()
     */
    private $name;

    /**
     *
     * @var string
     * @Gedmo\Slug(fields={"name"}, updatable=true)
     * @ORM\Column(name="slug", type="string", length=512, nullable=false)
     * @Assert\NotBlank()
     */
    private $slug;

    /**
     * @var integer
     *
     * @ORM\Column(name="step", type="smallint", nullable=true)
     */
    protected $step = 1;

    /**
     * @var \DateTime $startDate
     *
     * @ORM\Column(type="datetime", name="start_date")
     * @Assert\Type("\DateTime")
     */
    private $startDate;

    /**
     * @var \DateTime $endDate
     *
     * @ORM\Column(type="datetime", name="end_date")
     * @Assert\Type("\DateTime")
     */
    private $endDate;

    /**
     * @ORM\Column(type="decimal", scale=2)
     */
    private $price = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_limit", type="smallint", nullable=true)
     */
    protected $userLimit;

    /**
     * @var integer
     *
     * @ORM\Column(name="group_limit", type="smallint", nullable=true)
     */
    protected $groupLimit;

    /**
     *
     * @ORM\Column(name="show_netto_price", type="boolean")
     *
     */
    private $showNettoPrice = false;

    /**
     * @var boolean
     * @ORM\Column(name="payment_online", type="boolean")
     *
     */
    private $paymentOnline = false;

    /**
     * @var boolean
     * @ORM\Column(name="payment_transfer", type="boolean")
     */
    private $paymentTransfer = false;

    /**
     *
     * @var boolean
     * @ORM\Column(name="eticket", type="boolean")
     */
    private $eticket = false;

    /**
     *
     * @var string
     * @ORM\Column(name="contact_email", type="string", length=512, nullable=true)
     */
    private $contactEmail;

    /**
     *
     * @var string
     * @ORM\Column(name="contact_phone", type="string", length=512, nullable=true)
     */
    private $contactPhone;

    /**
     *
     * @var text
     * @ORM\Column(name="address", type="text", nullable=true)
     */
    private $address;

    /**
     *
     * @var text
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     *
     * @var text
     * @ORM\Column(name="welcome_mail", type="text", nullable=true)
     */
    private $welcomeMail;

    /**
     * @var \DateTime $createdAt
     *
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $createdAt;

    /**
     *
     * @var boolean
     * @ORM\Column(name="has_logo", type="boolean")
     *
     */
    private $hasLogo = false;

    /**
     * Bidirectional - One-To-Many (INVERSE SIDE)
     *
     * @ORM\OneToMany(targetEntity="nordmind\EventBundle\Entity\Group", mappedBy="event")
     */
    private $groups;

    /**
     *
     * 
     * @ORM\Column(name="longtitude", type="decimal", precision=9, scale=6, nullable=true)
     */
    private $longtitude;

    /**
     *
     * 
     * @ORM\Column(name="latitude", type="decimal", precision=9, scale=6, nullable=true)
     */
    private $latitude;

    public function increaseStep($step)
    {
        if ($this->step <= $step) {
            $this->step++;
        }
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getContentChangedAt()
    {
        return $this->contentChangedAt;
    }

    /**
     * @param \DateTime $contentChangedAt
     */
    public function setContentChangedAt($contentChangedAt)
    {
        $this->contentChangedAt = $contentChangedAt;
    }

    /**
     * @var \DateTime $updatedAt
     *
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $updatedAt;

    /**
     * @var \DateTime $contentChanged
     *
     * @ORM\Column(name="content_changed_at", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="change", field={"name"})
     */
    private $contentChangedAt;

    /**
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    private $deletedAt;

    public function __toString()
    {
        return $this->getName();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getDeletedAt()
    {
        return $this->deletedAt;
    }

    /**
     * @param mixed $deletedAt
     */
    public function setDeletedAt($deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }

    /**
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * @param \DateTime $startDate
     */
    public function setStartDate($startDate)
    {
        $this->startDate = $startDate;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * @param \DateTime $endDate
     */
    public function setEndDate($endDate)
    {
        $this->endDate = $endDate;
    }

    /**
     * @return mixed
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param mixed $price
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }

    /**
     * @return int
     */
    public function getUserLimit()
    {
        return $this->userLimit;
    }

    /**
     * @param int $userLimit
     */
    public function setUserLimit($userLimit)
    {
        $this->userLimit = $userLimit;
    }

    /**
     * @return bool
     */
    public function isShowNettoPrice()
    {
        return $this->showNettoPrice;
    }

    /**
     * @param bool $showNettoPrice
     */
    public function setShowNettoPrice($showNettoPrice)
    {
        $this->showNettoPrice = $showNettoPrice;
    }

    /**
     * @return bool
     */
    public function isPaymentOnline()
    {
        return $this->paymentOnline;
    }

    /**
     * @param bool $paymentOnline
     */
    public function setPaymentOnline($paymentOnline)
    {
        $this->paymentOnline = $paymentOnline;
    }

    /**
     * @return bool
     */
    public function isPaymentTransfer()
    {
        return $this->paymentTransfer;
    }

    /**
     * @param bool $paymentTransfer
     */
    public function setPaymentTransfer($paymentTransfer)
    {
        $this->paymentTransfer = $paymentTransfer;
    }

    /**
     * @return bool
     */
    public function isEticket()
    {
        return $this->eticket;
    }

    /**
     * @param bool $eticket
     */
    public function setEticket($eticket)
    {
        $this->eticket = $eticket;
    }

    /**
     * @return string
     */
    public function getContactEmail()
    {
        return $this->contactEmail;
    }

    /**
     * @param string $contactEmail
     */
    public function setContactEmail($contactEmail)
    {
        $this->contactEmail = $contactEmail;
    }

    /**
     * @return string
     */
    public function getContactPhone()
    {
        return $this->contactPhone;
    }

    /**
     * @param string $contactPhone
     */
    public function setContactPhone($contactPhone)
    {
        $this->contactPhone = $contactPhone;
    }

    /**
     * @return text
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * @param text $address
     */
    public function setAddress($address)
    {
        $this->address = $address;
    }

    /**
     * @return text
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param text $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return text
     */
    public function getWelcomeMail()
    {
        return $this->welcomeMail;
    }

    /**
     * @param text $welcomeMail
     */
    public function setWelcomeMail($welcomeMail)
    {
        $this->welcomeMail = $welcomeMail;
    }

    function getStep()
    {
        return $this->step;
    }

    function getGroupLimit()
    {
        return $this->groupLimit;
    }

    function setStep($step)
    {
        $this->step = $step;
    }

    function setGroupLimit($groupLimit)
    {
        $this->groupLimit = $groupLimit;
    }

    function getHasLogo()
    {
        return $this->hasLogo;
    }

    function setHasLogo($hasLogo)
    {
        $this->hasLogo = $hasLogo;
    }

    function getGroups()
    {
        return $this->groups;
    }

    function setGroups($groups)
    {
        $this->groups = $groups;
    }
    
    function getLongtitude()
    {
        return $this->longtitude;
    }

    function getLatitude()
    {
        return $this->latitude;
    }

    function setLongtitude($longtitude)
    {
        $this->longtitude = $longtitude;
    }

    function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }



}
