<?php

namespace nordmind\EventBundle\Entity;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @Gedmo\SoftDeleteable(fieldName="deletedAt", timeAware=false, hardDelete=false)
 * @ORM\Entity(repositoryClass="nordmind\EventBundle\Entity\EventRepository")
 * @ORM\Table(name="select_group")
 */
class Group
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     *
     * @var string
     * @ORM\Column(name="name", type="string", length=512, nullable=false)
     * @Assert\NotBlank()
     */
    private $name;

    /**
     * @var \DateTime $startDate
     *
     * @ORM\Column(type="datetime", name="start_date")
     * @Assert\Type("\DateTime")
     */
    private $startDate;

    /**
     * @var \DateTime $endDate
     *
     * @ORM\Column(type="datetime", name="end_date")
     * @Assert\Type("\DateTime")
     */
    private $endDate;

    /**
     * @ORM\Column(type="decimal", scale=2)
     */
    private $price = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_limit", type="smallint", nullable=true)
     */
    protected $userLimit;

    /**
     * @var integer
     *
     * @ORM\Column(name="group_limit", type="smallint", nullable=true)
     */
    protected $groupLimit;

    /**
     *
     * @ORM\Column(name="registration_button", type="boolean")
     *
     */
    private $registrationButton = true;

    /**
     * @var boolean
     * @ORM\Column(name="show_free_places", type="boolean")
     *
     */
    private $showFreePlaces = true;

    /**
     * @var \DateTime $createdAt
     *
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $createdAt;

    /**
     * @var \DateTime $updatedAt
     *
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $updatedAt;

    /**
     * @var \DateTime $contentChanged
     *
     * @ORM\Column(name="content_changed_at", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="change", field={"name"})
     */
    private $contentChangedAt;

    /**
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    private $deletedAt;

    /**
     * @$this->integer
     *
     * @ORM\Column(name="event_id", type="integer", nullable=false)
     */
    private $eventId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\EventBundle\Entity\Event", inversedBy="groups")
     * @ORM\JoinColumn(name="event_id", referencedColumnName="id")
     */
    protected $event;

//    /**
//     * Bidirectional - One-To-Many (INVERSE SIDE)
//     *
//     * @ORM\OneToMany(targetEntity="nordmind\EventBundle\Entity\UserGroup", mappedBy="groups", orphanRemoval=true, cascade={"persist"})
//     */
//    private $groupUsers;

    public function __toString()
    {
        return $this->getName();
    }

    function getId()
    {
        return $this->id;
    }

    function getName()
    {
        return $this->name;
    }

    function getStartDate()
    {
        return $this->startDate;
    }

    function getEndDate()
    {
        return $this->endDate;
    }

    function getPrice()
    {
        return $this->price;
    }

    function getUserLimit()
    {
        return $this->userLimit;
    }

    function getGroupLimit()
    {
        return $this->groupLimit;
    }

    function getRegistrationButton()
    {
        return $this->registrationButton;
    }

    function getShowFreePlaces()
    {
        return $this->showFreePlaces;
    }

    function getCreatedAt()
    {
        return $this->createdAt;
    }

    function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    function getContentChangedAt()
    {
        return $this->contentChangedAt;
    }

    function getDeletedAt()
    {
        return $this->deletedAt;
    }

    function setId($id)
    {
        $this->id = $id;
    }

    function setName($name)
    {
        $this->name = $name;
    }

    function setStartDate(\DateTime $startDate)
    {
        $this->startDate = $startDate;
    }

    function setEndDate(\DateTime $endDate)
    {
        $this->endDate = $endDate;
    }

    function setPrice($price)
    {
        $this->price = $price;
    }

    function setUserLimit($userLimit)
    {
        $this->userLimit = $userLimit;
    }

    function setGroupLimit($groupLimit)
    {
        $this->groupLimit = $groupLimit;
    }

    function setRegistrationButton($registrationButton)
    {
        $this->registrationButton = $registrationButton;
    }

    function setShowFreePlaces($showFreePlaces)
    {
        $this->showFreePlaces = $showFreePlaces;
    }

    function setCreatedAt(\DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
    }

    function setUpdatedAt(\DateTime $updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    function setContentChangedAt(\DateTime $contentChangedAt)
    {
        $this->contentChangedAt = $contentChangedAt;
    }

    function setDeletedAt($deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }

    function getEventId()
    {
        return $this->eventId;
    }

    function getEvent()
    {
        return $this->event;
    }

    function setEventId($eventId)
    {
        $this->eventId = $eventId;
    }

    function setEvent($event)
    {
        $this->event = $event;
    }

}
