<?php

namespace nordmind\EventBundle\Entity;

use Doctrine\ORM\EntityRepository;

class GroupRepository extends EntityRepository
{

    public function getAll($date = null, $operator = '>=', $sort = 'ASC')
    {

        $qb = $this->createQueryBuilder('c');
        if ($date) {
            $qb->andWhere("c.startDate {$operator} :date");
            $qb->setParameter('date', $date->format("Y-m-d H:i:s"));
        }
        $qb->orderBy('c.startDate', $sort);
        $query = $qb->getQuery();
        return $query->getResult();
    }

}
