<?php

namespace nordmind\EventBundle\Entity;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @Gedmo\SoftDeleteable(fieldName="deletedAt", timeAware=false, hardDelete=false)
 * @ORM\Entity(repositoryClass="nordmind\EventBundle\Entity\UserGroupRepository")
 * @ORM\Table(name="select_user_group")
 */
class UserGroup
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var \DateTime $createdAt
     *
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $createdAt;

    /**
     * @var \DateTime $updatedAt
     *
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $updatedAt;

    /**
     * @var \DateTime $contentChanged
     *
     * @ORM\Column(name="content_changed_at", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="change", field={"name"})
     */
    private $contentChangedAt;

    /**
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    private $deletedAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", name="expected_date", nullable=true)
     * @Assert\Type("\DateTime")
     */
    private $expectedDate;

    /**
     * @$this->integer
     *
     * @ORM\Column(name="user_id", type="integer", nullable=true)
     */
    private $userId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\UserBundle\Entity\User", inversedBy="groupUsers")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $user;

    /**
     * @$this->integer
     *
     * @ORM\Column(name="group_id", type="integer", nullable=true)
     */
    private $groupId;

    /**
     * @ORM\ManyToOne(targetEntity="nordmind\EventBundle\Entity\Group", inversedBy="userGroups")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $group;

    /**
     * @ORM\Column(type="decimal", scale=2)
     */
    private $price = 0;
    
    function getId()
    {
        return $this->id;
    }

    function getCreatedAt()
    {
        return $this->createdAt;
    }

    function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    function getContentChangedAt()
    {
        return $this->contentChangedAt;
    }

    function getDeletedAt()
    {
        return $this->deletedAt;
    }

    function getExpectedDate()
    {
        return $this->expectedDate;
    }

    function getUserId()
    {
        return $this->userId;
    }

    function getUser()
    {
        return $this->user;
    }

    function getGroupId()
    {
        return $this->groupId;
    }

    function getGroup()
    {
        return $this->group;
    }

    function getPrice()
    {
        return $this->price;
    }

    function setId($id)
    {
        $this->id = $id;
    }

    function setCreatedAt(\DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
    }

    function setUpdatedAt(\DateTime $updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }

    function setContentChangedAt(\DateTime $contentChangedAt)
    {
        $this->contentChangedAt = $contentChangedAt;
    }

    function setDeletedAt($deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }

    function setExpectedDate(\DateTime $expectedDate)
    {
        $this->expectedDate = $expectedDate;
    }

    function setUserId($userId)
    {
        $this->userId = $userId;
    }

    function setUser($user)
    {
        $this->user = $user;
    }

    function setGroupId($groupId)
    {
        $this->groupId = $groupId;
    }

    function setGroup($group)
    {
        $this->group = $group;
    }

    function setPrice($price)
    {
        $this->price = $price;
    }


}
