<?php

namespace nordmind\EventBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints as Asserts;
use Kiczort\PolishValidatorBundle\Validator\Constraints\Nip;
use nordmind\AppBundle\Utility;
use Symfony\Component\OptionsResolver\OptionsResolver;
use nordmind\EventBundle\Entity\Event;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;

class EventStepOneType extends AbstractType
{

    private $session;

    public function __construct(Session $session)
    {
        $this->session = $session;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('name', null, array('label' => 'Nazwa'))
                ->add('slug', null, array('label' => 'Adres url'))
                ->add('startDate', TextType::class, array('attr' => array('class' => 'datetimepicker'), 'label' => 'Data rozpoczęcia'))
                ->add('endDate', TextType::class, array('attr' => array('class' => 'datetimepicker'), 'label' => 'Data zakończenia'))
                ->add('userLimit', null, array('label' => 'Limit uczestników'))
                ->add('groupLimit', null, array('label' => 'Rejestracja grupowa – maksymalna liczba zgłaszanych uczestników'))
                ->add('price', MoneyType::class, array('attr' => array('class' => ''), 'currency' => '', 'label' => 'Cena brutto'))
                ->add('showNettoPrice', null, array('label' => 'Pokaż cenę netto', 'attr' => array('id' => 'show_netto_price', 'class' => 'chk-col-pink')))
                ->add('paymentOnline', null, array('label' => 'Płatności online', 'attr' => array('id' => 'payment_online', 'class' => 'chk-col-pink')))
                ->add('paymentTransfer', null, array('label' => 'Przelew bankowy', 'attr' => array('id' => 'payment_transfer', 'class' => 'chk-col-pink')))
                ->add('send', SubmitType::class, array('label' => 'Zapisz', 'attr' => array('class' => 'btn btn-primary')));

        $builder->addEventListener(
                FormEvents::SUBMIT, function (FormEvent $event)
        {
            $form = $event->getForm();
            $data = $event->getData();
            $startDate = $data->getStartDate();
            $data->setStartDate(new \DateTime($startDate));
            $endDate = $data->getEndDate();
            $data->setEndDate(new \DateTime($endDate));
        }
        );
        $builder->addEventListener(FormEvents::POST_SET_DATA, array($this, 'onPostSetData'));
    }

    function onPostSetData(FormEvent $aEvent)
    {
        $event = $aEvent->getData();
        $form = $aEvent->getForm();
        if ($event->getStartDate()) {
            $form->get("startDate")->setData($event->getStartDate()->format("d-m-Y H:i"));
        }
        if ($event->getEndDate()) {
            $form->get("endDate")->setData($event->getEndDate()->format("d-m-Y H:i"));
        }
    }

    public function getName()
    {
        return 'event_form';
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Event::class,
        ));
    }

}
