<?php

namespace nordmind\EventBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints as Asserts;
use Kiczort\PolishValidatorBundle\Validator\Constraints\Nip;
use nordmind\AppBundle\Utility;
use Symfony\Component\OptionsResolver\OptionsResolver;
use nordmind\EventBundle\Entity\Event;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\HttpFoundation\Session\Session;

class EventStepTwoType extends AbstractType
{

    private $session;

    public function __construct(Session $session)
    {
        $this->session = $session;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
                ->add('contactEmail', null, array('label' => 'Adres email organizatora', 'empty_data' => $this->session->get('issuer_email')))
                ->add('contactPhone', null, array('label' => 'Telefon organizatora', 'empty_data' => $this->session->get('issuer_email')))
                ->add('address', null, array('label' => 'Adres'))
                ->add('description', null, array('label' => 'Opis'))
                ->add('send', SubmitType::class, array('label' => 'Zapisz', 'attr' => array('class' => 'btn btn-primary')));
    }

    public function getName()
    {
        return 'event_two';
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Event::class,
        ));
    }

}
