<?php

namespace nordmind\EventBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints as Asserts;
use Kiczort\PolishValidatorBundle\Validator\Constraints\Nip;
use nordmind\AppBundle\Utility;
use Symfony\Component\OptionsResolver\OptionsResolver;
use nordmind\EventBundle\Entity\Event;
use nordmind\EventBundle\Entity\Group;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;

class GroupType extends AbstractType
{

//    private $session;
//
//    public function __construct(Session $session)
//    {
//        $this->session = $session;
//    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('name', null, array('label' => 'Nazwa'))
                ->add('startDate', TextType::class, array('attr' => array('class' => 'datetimepicker'), 'label' => 'Początek rejestracji'))
                ->add('endDate', TextType::class, array('attr' => array('class' => 'datetimepicker'), 'label' => 'Koniec rejestracji'))
                ->add('userLimit', null, array('label' => 'Limit uczestników'))
                ->add('groupLimit', null, array('label' => 'Rejestracja grupowa – maksymalna liczba zgłaszanych uczestników'))
                ->add('price', MoneyType::class, array('attr' => array('class' => ''), 'currency' => '', 'label' => 'Cena brutto'))
                ->add('registrationButton', null, array('label' => 'Pokaż przycisk rejestracji do grupy na stronie rejestracji', 'attr' => array('id' => 'payment_online', 'class' => 'chk-col-pink')))
                ->add('showFreePlaces', null, array('label' => 'Pokaż liczbę wolnych miejsc na stronie rejestracji', 'attr' => array('id' => 'payment_transfer', 'class' => 'chk-col-pink')))
                ->add('send', SubmitType::class, array('label' => 'Zapisz', 'attr' => array('class' => 'btn btn-primary')));

        $builder->addEventListener(
                FormEvents::PRE_SUBMIT, function (FormEvent $event)
        {
            $form = $event->getForm();
            $data = $event->getData();


            $startDate = $data['startDate'];
            $data['startDate'] = new \DateTime($startDate);
            $event->setData($data);

            $endDate = $data['endDate'];
            $data['endDate'] = new \DateTime($endDate);
            $event->setData($data);
        }
        );
        $builder->addEventListener(FormEvents::POST_SET_DATA, array($this, 'onPostSetData'));
    }

    function onPostSetData(FormEvent $aEvent)
    {
        $event = $aEvent->getData();
        $form = $aEvent->getForm();
        if ($event->getStartDate()) {
            $form->get("startDate")->setData($event->getStartDate()->format("d.m.Y H:i"));
        }
        if ($event->getEndDate()) {
            $form->get("endDate")->setData($event->getEndDate()->format("d.m.Y H:i"));
        }
    }

    public function getName()
    {
        return 'group_form';
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Group::class,
        ));
    }

}
