<?php

namespace nordmind\MessageBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use nordmind\AppBundle\Utility;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;


class DefaultController extends Controller
{

    /**
     * @Route("/inbox/{create}/{participantId}", name="nordmind_message_inbox")
     */
    public function inboxAction($create = false, $participantId = null)
    {
        $provider = $this->container->get('fos_message.provider');

        $inboxThreads = Utility::getIdArray($provider->getInboxThreads());
        $sentThreads = Utility::getIdArray($provider->getSentThreads());

        $threads = array_replace($inboxThreads, $sentThreads);

        return $this->render('nordmindMessageBundle:Default:inbox.html.twig', array('threads' => $threads, 'create' => $create, 'participantId' => $participantId));
    }

    /**
     * @Route("/thread/{id}", name="nordmind_message_thread")
     */
    public function threadAction($id = null)
    {
        $provider = $this->container->get('fos_message.provider');

        $thread = $provider->getThread($id);
        $messages = $thread->getMessages();

        return $this->render('nordmindMessageBundle:Default:thread.html.twig', array('thread' => $thread, 'messages' => $messages));
    }

    /**
     * @Route("/getNewMessages", name="nordmind_message_get_new_messages")
     */
    public function getNewMessagesAction(Request $request)
    {
        $provider = $this->container->get('fos_message.provider');
        $id = $request->request->get('id');
        $date = $request->request->get('date');
        $thread = $provider->getThread($id);
        $messages = $thread->getNewMessages($date);
        $messageArray = array();
        foreach ($messages as $message)
        {
            $tmpArray["id"] = $message->getId();
            $tmpArray["createdAt"] = $message->getCreatedAt()->format("d/F H:i");
            $tmpArray["date"] = $message->getCreatedAt()->format("Y-m-d H:i:s");
            $tmpArray["body"] = $message->getBody();
            $tmpArray["user"] = $message->getSender()->getId();
            $tmpArray["logo"] = $message->getSender()->getLogoSource();
            $messageArray[] = $tmpArray;
        }
//        $encoders = array(new JsonEncoder());
//        $normalizers = array(new ObjectNormalizer());
//
//        $serializer = new Serializer($normalizers, $encoders);

        //$jsonMessages = $serializer->serialize($messageArray, 'json');
        return new JsonResponse($messageArray);
    }

//    /**
//     * @Route("/send", name="nordmind_message_send")
//     */
//    public function sendAction()
//    {
//        $em = $this->getDoctrine()->getManager();
//        $users = $em->getRepository('nordmindUserBundle:User')->findAll();
//        $composer = $this->container->get('fos_message.composer');
//        $message = $composer->newThread()
//                ->setSender($users[1])
//                ->addRecipient($users[0])
//                ->addRecipient($users[2])
//                ->setSubject('Nowa rozmowa')
//                ->setBody('This is a test message')
//                ->getMessage();
//
//        $message = $composer->reply($thread)
//                ->setSender($clyde)
//                ->setBody('This is the answer to the test message')
//                ->getMessage();
//
//        $sender = $this->container->get('fos_message.sender');
//        $sender->send($message);
//        return $this->render('nordmindMessageBundle:Default:inbox.html.twig', array('threads' => $threads));
//    }

    /**
     * @Route("/create", name="nordmind_message_create")
     */
    public function createAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $users = $em->getRepository('nordmindUserBundle:User')->getWithoutId($this->getUser()->getId());
        return $this->render('nordmindMessageBundle:Default:create.html.twig', array("users" => $users, "selected" => $request->request->get('id')));
    }

    /**
     * @Route("/reply", name="nordmind_message_reply")
     */
    public function replyAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $provider = $this->container->get('fos_message.provider');
        $composer = $this->container->get('fos_message.composer');
        if ($request->request->get('id')) {
            $thread = $provider->getThread($request->request->get('id'));
            $message = $composer->reply($thread)
                    ->setSender($this->getUser())
                    ->setBody($request->request->get('value'))
                    ->getMessage();
        } else {
            $recipients = $request->request->get('recipients');
            $users = Utility::getIdArray($em->getRepository('nordmindUserBundle:User')->findAll());
            $thread = $composer->newThread();
            $thread->setSender($this->getUser());
            foreach ($recipients as $recipient) {
                $thread->addRecipient($users[$recipient]);
            }
            $message = $thread->setSubject('Nowa rozmowa')
                    ->setBody($request->request->get('value'))
                    ->getMessage();
        }
        $sender = $this->container->get('fos_message.sender');
        $sender->send($message);

        $response = new JsonResponse(array('message' => "Zmiany zostały zapisane.", "threadId" => $message->getThread()->getId()));
        return $response;
    }

}
