<?php

namespace nordmind\MessageBundle\Service;

use Doctrine\ORM\Event\LifecycleEventArgs;
use nordmind\AppBundle\Entity\NotificationUser;
use nordmind\AppBundle\Entity\Notification;
use nordmind\UserBundle\Entity\User;
use Doctrine\ORM\EntityManager;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;

class NotificationManager
{
    private $em;
    private $tokenStorage;

    public function __construct(EntityManager $em, TokenStorage $tokenStorage)
    {
        $this->em = $em;
        $this->tokenStorage = $tokenStorage;
    }

    public function getNumber()
    {
        $userNotifcations = $this->em->getRepository('nordmindMessageBundle:Message')->findBy(array("userId" => $this->tokenStorage->getToken()->getUser()->getId(), 'seen' => false));
        return count($userNotifcations);
    }

}
