<?php

namespace nordmind\UserBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use nordmind\UserBundle\Entity\User;
use nordmind\UserBundle\Form\Type\UserType;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use nordmind\UserBundle\Form\Type\RegistrationClientFormType;

class DefaultController extends Controller
{
    /**
     * @Route("/registerClient", name="nordmind_user_register_client")
     */
    public function registerClientAction(Request $request)
    {
        $user = new User();
        $form = $this->createForm(RegistrationClientFormType::class, $user, array(
            'action' => $this->generateUrl('nordmind_user_register_client'),
        ));
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $em = $this->getDoctrine()->getManager();
            $email_exist = $em->getRepository('nordmindUserBundle:User')->findOneBy(array('email' => $data->getEmail()));
            if ($email_exist) {
                $form->get('email')->addError(new FormError('The email is already used.'));
                return $this->render('nordmindUserBundle:Registration:registerClient.html.twig', array('form' => $form->createView()));
            }
            $mailer = $this->container->get('nordmind.app.custom_fos_user_mailer');
            $tokenGenerator = $this->container->get('fos_user.util.token_generator');

            $user->setRoles(array());
            $user->addRole('ROLE_CLIENT');
            $user->setEnabled(false);
            $user->setPlainPassword($data->getPlainPassword());
            $user->setEmail($data->getEmail());
            $user->setUsername($data->getEmail());
            $user->setName($data->getName());
            $user->setPasswordRequestedAt(new \DateTime());
            $user->setLastName($data->getLastName());
            if (null === $user->getConfirmationToken()) {
                $user->setConfirmationToken($tokenGenerator->generateToken());
            }
            $em->persist($user);
            $em->flush();
            $mailer->sendConfirmationEmailMessage($user);
            $request->getSession()->set('fos_user_send_confirmation_email/email', $user->getEmail());
            return $this->redirectToRoute('fos_user_registration_check_email');
        }
        return $this->render('nordmindUserBundle:Registration:registerClient.html.twig', array('form' => $form->createView()));
    }
}
