<?php

namespace nordmind\UserBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Mapping;
use nordmind\AppBundle\Utility;

class UserRepository extends EntityRepository
{
    const USERS_PER_PAGE = 10;

    public function getAll($role, $name)
    {
        return $this->createQueryBuilder('user')
            ->where('user.roles LIKE :role')
            ->andWhere('CONCAT(user.name, \' \', user.lastName) LIKE :name')
            ->setParameter('role', '%'.$role.'%')
            ->setParameter('name', '%'.$name.'%')
            ->getQuery()->getResult();
    }

    public function getUsersWithRolesQuery($role)
    {
        return $this->createQueryBuilder('user')
                        ->where('user.roles LIKE :role')
                        ->setParameter('role', '%'.$role.'%');
    }
    
    public function getUsersWithRoles($role)
    {
        return $this->getUsersWithRolesQuery($role)->getQuery()->getResult();
    }

    public function getWithoutId($id)
    {
        $qb = $this->createQueryBuilder('u');
        $qb->where('u.id != :identifier')
                ->setParameter('identifier', $id);

        return $qb->getQuery()
                        ->getResult();
    }
    
    public function getUserAccessArray($user)
    {
        if ($user->hasRole('ROLE_SUPER_ADMIN'))
        {
            return null;
        }
        else if ($user->hasRole('ROLE_ADMIN'))
        {
            $supervised = array();
            foreach ($user->getSupervised() as $s)
            {
                $supervised[] = $s->getId();
            }
            array_push($supervised, $user->getId());
            return $supervised;
        }
        return array($user->getId());
    }

    public function search($searchProfession, $searchArtist, $searchTag, $searchCategories, $searchThemes, $page, $sortBy = 'date')
    {
        $qb = $this->createQueryBuilder('u');
        $qb->select('u');
        $qb->distinct();
        $qb->leftJoin('u.photos', 'p');
        if ($searchProfession)
        {

        }
        if ($searchCategories) {
            $qb->leftJoin('p.categories', 'c');
            $qb->andWhere('c.category IN (:categories)')
                ->setParameter('categories', $searchCategories);
        }
        if ($searchThemes) {
            $qb->leftJoin('p.themes', 't');
            $qb->andWhere('t.theme IN (:themes)')
                ->setParameter('themes', $searchThemes);
        }
        if ($searchTag) {
            $qb->leftJoin('p.tags', 'ta');
            $qb->andWhere('ta.tag = :tag')
                ->setParameter('tag', $searchTag);
        }
        if ($searchArtist) {
            $qb->andWhere('CONCAT(u.name, \' \',u.lastName) = :userId')
                ->setParameter('userId', $searchArtist);
        }
        $qb->andWhere('u.hasLogo = true');
        if($sortBy = 'name')
        {
            $qb->orderBy('u.lastName', 'DESC');
        }
        else
        {
            $qb->orderBy('u.createdAt', 'DESC');
        }
        $qb->setMaxResults(self::USERS_PER_PAGE)->setFirstResult(($page-1)*self::USERS_PER_PAGE);
        $query = $qb->getQuery();
        return $query->getResult();
    }

}
