<?php

namespace nordmind\UserBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints as Asserts;
use nordmind\AppBundle\Utility;
use nordmind\UserBundle\Entity\User;
use nordmind\UserBundle\Entity\UserRepository;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class UserType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
                ->add('name', TextType::class, array('required' => true, 'label' => 'Imię'))
                ->add('last_name', TextType::class, array('required' => true, 'label' => 'Nazwisko'))
                ->add('email', TextType::class, array('required' => true, 'label' => 'Adres email'))
                ->add('phone', TextType::class, array('required' => false, 'label' => 'Telefon'))
                ->add('singleRole', ChoiceType::class, array(
                    'choices' => User::getRoleArray(),
                    // *this line is important*
                    'choices_as_values' => false,
                    'multiple' => false,
                    'label' => 'Stanowisko',
                    'mapped' => false,
                ))
        ;

//        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event)
//        {
//            $user = $event->getData();
//            $form = $event->getForm();
//        });
    }

}
